/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ExtendedFileFilter;
import gui.JIQScreen;
import gui.Settings;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import machine.Iq;

public class JIQ151
extends JFrame {
    private final String[] loadExt = new String[]{".wav", ".csw"};
    private final String[] saveExt = new String[]{".csw"};
    private final ExtendedFileFilter loadFlt = new ExtendedFileFilter("WAV or CSW files", this.loadExt);
    private final ExtendedFileFilter saveFlt = new ExtendedFileFilter("CSW files", this.saveExt);
    private Iq m;
    private JIQScreen scr;
    private ButtonGroup buttonGroup1;
    private JFileChooser fc;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JMenuItem mExit;
    private JCheckBoxMenuItem mInvert;
    private JMenuItem mLoad;
    private JRadioButtonMenuItem mPlay;
    private JRadioButtonMenuItem mRecord;
    private JMenuItem mSave;
    private JMenuItem mSettings;

    public JIQ151() {
        this.initComponents();
        this.initEmulator();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.fc = new JFileChooser();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.mLoad = new JMenuItem();
        this.mSave = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mSettings = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.mExit = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.mPlay = new JRadioButtonMenuItem();
        this.mRecord = new JRadioButtonMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.mInvert = new JCheckBoxMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("jIQ151");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JIQ151.this.formWindowClosing(evt);
            }
        });
        this.jMenu1.setText("File");
        this.mLoad.setText("Open LOAD tape");
        this.mLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIQ151.this.mLoadActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mLoad);
        this.mSave.setText("Open SAVE tape");
        this.mSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIQ151.this.mSaveActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mSave);
        this.jMenu1.add(this.jSeparator1);
        this.mSettings.setText("Settings");
        this.mSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIQ151.this.mSettingsActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mSettings);
        this.jMenu1.add(this.jSeparator3);
        this.mExit.setText("Exit");
        this.mExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIQ151.this.mExitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mExit);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Tape recorder");
        this.buttonGroup1.add(this.mPlay);
        this.mPlay.setSelected(true);
        this.mPlay.setText("Play");
        this.mPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIQ151.this.RecorderAction(evt);
            }
        });
        this.jMenu2.add(this.mPlay);
        this.buttonGroup1.add(this.mRecord);
        this.mRecord.setForeground(Color.red);
        this.mRecord.setText("Record");
        this.mRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIQ151.this.RecorderAction(evt);
            }
        });
        this.jMenu2.add(this.mRecord);
        this.jMenu2.add(this.jSeparator2);
        this.mInvert.setSelected(true);
        this.mInvert.setText("Invert signal");
        this.mInvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIQ151.this.mInvertActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mInvert);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void mLoadActionPerformed(ActionEvent evt) {
        boolean pau = this.m.isPaused();
        this.m.stopEmulation();
        this.fc.setDialogTitle("Open LOAD tape");
        this.fc.setFileFilter(this.loadFlt);
        int val = this.fc.showOpenDialog(this);
        if (val == 0) {
            try {
                this.m.openLoadTape(this.fc.getSelectedFile().getCanonicalPath());
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (!pau) {
            this.m.startEmulation();
        }
    }

    private void mSaveActionPerformed(ActionEvent evt) {
        boolean pau = this.m.isPaused();
        this.m.stopEmulation();
        this.fc.setDialogTitle("Open SAVE tape");
        this.fc.setFileFilter(this.saveFlt);
        int val = this.fc.showSaveDialog(this);
        if (val == 0) {
            try {
                String s = this.fc.getSelectedFile().getCanonicalPath();
                if (!s.endsWith(".csw")) {
                    s = s + ".csw";
                }
                this.m.openSaveTape(s);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (!pau) {
            this.m.startEmulation();
        }
    }

    private void mExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void RecorderAction(ActionEvent evt) {
        this.m.setTapeMode("Record".equals(evt.getActionCommand()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.m.shutdownCleanup();
    }

    private void mInvertActionPerformed(ActionEvent evt) {
        this.m.setTapeInvert(this.mInvert.isSelected());
    }

    private void mSettingsActionPerformed(ActionEvent evt) {
        boolean pau = this.m.isPaused();
        this.m.stopEmulation();
        Settings set = new Settings();
        set.showDialog(this.m.getConfig());
        this.m.clearScreen();
        if (set.isResetNeeded()) {
            this.m.Reset(false);
        }
        set.dispose();
        if (!pau) {
            this.m.startEmulation();
        }
    }

    private void initEmulator() {
        this.m = new Iq();
        this.scr = new JIQScreen();
        this.m.setScreen(this.scr);
        this.scr.setImage(this.m.getImage());
        this.getContentPane().add((Component)this.scr, "Center");
        this.pack();
        this.addKeyListener(this.m.getKeyboard());
        this.m.start();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JIQ151.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(JIQ151.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JIQ151.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(JIQ151.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JIQ151().setVisible(true);
            }
        });
    }
}

