/*
 * Decompiled with CFR 0.152.
 */
package machine;

public class Grafik {
    public byte[] GVRam = new byte[16384];
    public boolean Enabled;
    public boolean ShowGR;
    public boolean BitAcces;
    public boolean PenOn;
    public int D0;
    public int D1;
    private byte[][] GrafRam = new byte[64][256];
    private byte[] zrct = new byte[256];
    private static final char[] gbt0 = new char[]{'\u0001', '\u0002', '\u0004', '\b', '\u0010', ' ', '@', '\u0080'};
    private static final char[] gbt1 = new char[]{'\u00fe', '\u00fd', '\u00fb', '\u00f7', '\u00ef', '\u00df', '\u00bf', '\u007f'};
    private int[][] gvradr = new int[64][256];

    public void Init() {
        for (int j = 0; j < 256; ++j) {
            this.zrct[j] = this.zrcadlo(j);
        }
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 256; ++j) {
                this.gvradr[i][j] = i + 16320 - j * 64;
            }
        }
        this.BitAcces = false;
        this.PenOn = false;
        this.ShowGR = true;
        this.Enabled = true;
    }

    public void wpD2(int value) {
        this.BitAcces = (value & 1) != 1;
        this.ShowGR = (value & 8) == 8;
        this.PenOn = (value & 2) == 2;
    }

    public void wpD3(int value) {
    }

    public void wpD4(int value) {
        int i = this.D0 & 0x3F;
        int j = this.D1 & 0xFF;
        if (this.BitAcces) {
            int a = this.GrafRam[i][j] & 0xFF;
            int c = value >> 5 & 7;
            a = this.PenOn ? (a &= gbt1[c]) : (a |= gbt0[c]);
            this.GrafRam[i][j] = (byte)a;
            this.GVRam[this.gvradr[i][j]] = this.zrct[this.GrafRam[i][j] & 0xFF];
        } else {
            this.GrafRam[i][j] = (byte)value;
            this.GVRam[this.gvradr[i][j]] = this.zrct[this.GrafRam[i][j] & 0xFF];
        }
    }

    public int rpD4() {
        int i = this.D0 & 0x3F;
        int j = this.D1 & 0xFF;
        return this.GrafRam[i][j] & 0xFF;
    }

    private byte zrcadlo(int xx) {
        int pom = 0;
        if ((xx & 1) == 1) {
            pom |= 0x80;
        }
        if ((xx & 2) == 2) {
            pom |= 0x40;
        }
        if ((xx & 4) == 4) {
            pom |= 0x20;
        }
        if ((xx & 8) == 8) {
            pom |= 0x10;
        }
        if ((xx & 0x10) == 16) {
            pom |= 8;
        }
        if ((xx & 0x20) == 32) {
            pom |= 4;
        }
        if ((xx & 0x40) == 64) {
            pom |= 2;
        }
        if ((xx & 0x80) == 128) {
            pom |= 1;
        }
        return (byte)pom;
    }
}

