/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.util.Arrays;
import machine.Clock;
import machine.MemIoOps;
import machine.NotifyOps;

public class I8085 {
    private final Clock clock;
    private final MemIoOps MemIoImpl;
    private final NotifyOps NotifyImpl;
    private int opCode;
    public boolean astart;
    private boolean execDone;
    private static final int C_MASK = 1;
    private static final int V_MASK = 2;
    private static final int P_MASK = 4;
    private static final int H_MASK = 16;
    private static final int U_MASK = 32;
    private static final int Z_MASK = 64;
    private static final int S_MASK = 128;
    private int regA;
    private int regB;
    private int regC;
    private int regD;
    private int regE;
    private int regH;
    private int regL;
    private int Flags;
    private boolean carryFlag;
    private boolean UFlag;
    private boolean VFlag;
    private int regSim;
    private int regPC;
    private int regSP;
    private boolean pendingEI = false;
    private boolean activeTRAP = false;
    private boolean activeINT = false;
    private boolean intack = false;
    private boolean halted = false;
    private int memptr;
    private static final int[] fl = new int[256];
    private boolean[] breakpointAt = new boolean[65536];

    public I8085(Clock clock, MemIoOps memory, NotifyOps notify) {
        this.clock = clock;
        this.MemIoImpl = memory;
        this.NotifyImpl = notify;
        this.execDone = false;
        Arrays.fill(this.breakpointAt, false);
        this.reset();
    }

    public final boolean isPendingEI() {
        return this.pendingEI;
    }

    public final void setPendingEI(boolean state) {
        this.pendingEI = state;
    }

    public final boolean isActiveInt() {
        return this.activeINT;
    }

    public final boolean isIntAck() {
        return this.intack;
    }

    public final void setActiveInt(boolean state) {
        this.activeINT = state;
    }

    public final int getRegA() {
        return this.regA;
    }

    public final void setRegA(int value) {
        this.regA = value & 0xFF;
    }

    public final int getRegB() {
        return this.regB;
    }

    public final void setRegB(int value) {
        this.regB = value & 0xFF;
    }

    public final int getRegC() {
        return this.regC;
    }

    public final void setRegC(int value) {
        this.regC = value & 0xFF;
    }

    public final int getRegD() {
        return this.regD;
    }

    public final void setRegD(int value) {
        this.regD = value & 0xFF;
    }

    public final int getRegE() {
        return this.regE;
    }

    public final void setRegE(int value) {
        this.regE = value & 0xFF;
    }

    public final int getRegH() {
        return this.regH;
    }

    public final void setRegH(int value) {
        this.regH = value & 0xFF;
    }

    public final int getRegL() {
        return this.regL;
    }

    public final void setRegL(int value) {
        this.regL = value & 0xFF;
    }

    public final int getRegAF() {
        return this.regA << 8 | (this.carryFlag ? this.Flags | 1 : this.Flags);
    }

    public final void setRegAF(int word) {
        this.regA = word >>> 8 & 0xFF;
        this.Flags = word & 0xFE;
        this.carryFlag = (word & 1) != 0;
    }

    public final int getRegBC() {
        return this.regB << 8 | this.regC;
    }

    public final void setRegBC(int word) {
        this.regB = word >>> 8 & 0xFF;
        this.regC = word & 0xFF;
    }

    private void incRegBC() {
        int reg16 = this.getRegBC();
        ++reg16;
        this.UFlag = (reg16 &= 0xFFFF) == 32768;
        this.setRegBC(reg16);
    }

    private void decRegBC() {
        int reg16 = this.getRegBC();
        --reg16;
        this.UFlag = (reg16 &= 0xFFFF) == Short.MAX_VALUE;
        this.setRegBC(reg16);
    }

    public final int getRegDE() {
        return this.regD << 8 | this.regE;
    }

    public final void setRegDE(int word) {
        this.regD = word >>> 8 & 0xFF;
        this.regE = word & 0xFF;
    }

    private void incRegDE() {
        int reg16 = this.getRegDE();
        ++reg16;
        this.UFlag = (reg16 &= 0xFFFF) == 32768;
        this.setRegDE(reg16);
    }

    private void decRegDE() {
        int reg16 = this.getRegDE();
        --reg16;
        this.UFlag = (reg16 &= 0xFFFF) == Short.MAX_VALUE;
        this.setRegDE(reg16);
    }

    public final int getRegHL() {
        return this.regH << 8 | this.regL;
    }

    public final void setRegHL(int word) {
        this.regH = word >>> 8 & 0xFF;
        this.regL = word & 0xFF;
    }

    private void incRegHL() {
        int reg16 = this.getRegHL();
        ++reg16;
        this.UFlag = (reg16 &= 0xFFFF) == 32768;
        this.setRegHL(reg16);
    }

    private void decRegHL() {
        int reg16 = this.getRegHL();
        --reg16;
        this.UFlag = (reg16 &= 0xFFFF) == Short.MAX_VALUE;
        this.setRegHL(reg16);
    }

    public final int getRegPC() {
        return this.regPC;
    }

    public final void setRegPC(int address) {
        this.regPC = address & 0xFFFF;
    }

    public final int getRegSP() {
        return this.regSP & 0xFFFF;
    }

    public final void setRegSP(int word) {
        this.regSP = word & 0xFFFF;
    }

    private void incRegSP() {
        int reg16 = this.getRegSP();
        ++reg16;
        this.UFlag = (reg16 &= 0xFFFF) == 32768;
        this.setRegSP(reg16);
    }

    private void decRegSP() {
        int reg16 = this.getRegSP();
        --reg16;
        this.UFlag = (reg16 &= 0xFFFF) == Short.MAX_VALUE;
        this.setRegSP(reg16);
    }

    public final int getRegSim() {
        return this.regSim & 0xFF;
    }

    public final void setRegSim(int value) {
        this.regSim = value & 0xFF;
    }

    public final int getMemPtr() {
        return this.memptr & 0xFFFF;
    }

    public final void setMemPtr(int word) {
        this.memptr = word & 0xFFFF;
    }

    public final boolean isCarryFlag() {
        return this.carryFlag;
    }

    public final void setCarryFlag(boolean state) {
        this.carryFlag = state;
    }

    public final boolean isVFlag() {
        return this.VFlag;
    }

    public final void setVFlag(boolean state) {
        this.VFlag = state;
    }

    public final boolean isPFlag() {
        return (this.Flags & 4) != 0;
    }

    public final void setPFlag(boolean state) {
        this.Flags = state ? (this.Flags |= 4) : (this.Flags &= 0xFFFFFFFB);
    }

    public final boolean isHFlag() {
        return (this.Flags & 0x10) != 0;
    }

    public final void setHFlag(boolean state) {
        this.Flags = state ? (this.Flags |= 0x10) : (this.Flags &= 0xFFFFFFEF);
    }

    public final boolean isUFlag() {
        return this.UFlag;
    }

    public final void setUFlag(boolean state) {
        this.UFlag = state;
    }

    public final boolean isZFlag() {
        return (this.Flags & 0x40) != 0;
    }

    public final void setZFlag(boolean state) {
        this.Flags = state ? (this.Flags |= 0x40) : (this.Flags &= 0xFFFFFFBF);
    }

    public final boolean isSFlag() {
        return (this.Flags & 0x80) != 0;
    }

    public final void setSFlag(boolean state) {
        this.Flags = state ? (this.Flags |= 0x80) : (this.Flags &= 0xFFFFFF7F);
    }

    public final int getFlags() {
        int flg = this.Flags;
        if (this.carryFlag) {
            flg |= 1;
        }
        if (this.UFlag) {
            flg |= 0x20;
        }
        if (this.VFlag) {
            flg |= 2;
        }
        return flg;
    }

    public final void setFlags(int regF) {
        this.Flags = regF & 0xFFFFFFDC;
        this.carryFlag = (regF & 1) != 0;
        this.UFlag = (regF & 0x20) != 0;
        this.VFlag = (regF & 2) != 0;
    }

    public final boolean isHalted() {
        return this.halted;
    }

    public void setHalted(boolean state) {
        this.halted = state;
    }

    public final void reset() {
        this.regPC = 0;
        this.regSP = 65535;
        this.regSim = 0;
        this.pendingEI = false;
        this.halted = false;
        this.activeTRAP = false;
        this.activeINT = false;
    }

    private int inc8(int oper8) {
        oper8 = oper8 + 1 & 0xFF;
        this.Flags = fl[oper8];
        if ((oper8 & 0xF) == 0) {
            this.Flags |= 0x10;
        }
        this.VFlag = oper8 == 128;
        return oper8;
    }

    private int dec8(int oper8) {
        oper8 = oper8 - 1 & 0xFF;
        this.Flags = fl[oper8];
        if ((oper8 & 0xF) == 15) {
            this.Flags |= 0x10;
        }
        this.VFlag = oper8 == 127;
        return oper8;
    }

    private void add(int oper8) {
        int res = this.regA + oper8;
        this.carryFlag = res > 255;
        this.Flags = fl[res &= 0xFF];
        if ((res & 0xF) < (this.regA & 0xF)) {
            this.Flags |= 0x10;
        }
        this.VFlag = ((this.regA ^ ~oper8) & (this.regA ^ res)) > 127;
        this.regA = res;
    }

    private void adc(int oper8) {
        int res = this.regA + oper8;
        if (this.carryFlag) {
            ++res;
        }
        this.carryFlag = res > 255;
        this.Flags = fl[res &= 0xFF];
        if (((this.regA ^ oper8 ^ res) & 0x10) != 0) {
            this.Flags |= 0x10;
        }
        this.VFlag = ((this.regA ^ ~oper8) & (this.regA ^ res)) > 127;
        this.regA = res;
    }

    private int add16(int reg16, int oper16) {
        this.carryFlag = (oper16 += reg16) > 65535;
        this.VFlag = oper16 > Short.MAX_VALUE;
        this.memptr = reg16 + 1;
        return oper16 &= 0xFFFF;
    }

    private void sub(int oper8) {
        int res = this.regA - oper8;
        this.carryFlag = res < 0;
        this.Flags = fl[res &= 0xFF];
        if ((res & 0xF) > (this.regA & 0xF)) {
            this.Flags |= 0x10;
        }
        this.VFlag = ((this.regA ^ oper8) & (this.regA ^ res)) > 127;
        this.regA = res;
    }

    private void sbc(int oper8) {
        int res = this.regA - oper8;
        if (this.carryFlag) {
            --res;
        }
        this.carryFlag = res < 0;
        this.Flags = fl[res &= 0xFF];
        if (((this.regA ^ oper8 ^ res) & 0x10) != 0) {
            this.Flags |= 0x10;
        }
        this.VFlag = ((this.regA ^ oper8) & (this.regA ^ res)) > 127;
        this.regA = res;
    }

    private void sub16(int reg16) {
        int regHL = this.getRegHL();
        this.memptr = regHL + 1;
        int res = regHL - reg16;
        this.carryFlag = res < 0;
        this.setRegHL(res &= 0xFFFF);
        this.Flags = fl[this.regH];
        if (res != 0) {
            this.Flags &= 0xFFFFFFBF;
        }
    }

    private void and(int oper8) {
        this.regA &= oper8;
        this.carryFlag = false;
        this.Flags = fl[this.regA] & 0xFFFFFFEF;
    }

    public final void xor(int oper8) {
        this.regA = (this.regA ^ oper8) & 0xFF;
        this.carryFlag = false;
        this.Flags = fl[this.regA] & 0xFFFFFFEF;
    }

    private void or(int oper8) {
        this.regA = (this.regA | oper8) & 0xFF;
        this.carryFlag = false;
        this.Flags = fl[this.regA] & 0xFFFFFFEF;
    }

    public final void cp(int oper8) {
        int res = this.regA - (oper8 & 0xFF);
        this.carryFlag = res < 0;
        this.Flags = fl[res &= 0xFF];
        if ((res & 0xF) > (this.regA & 0xF)) {
            this.Flags |= 0x10;
        }
        this.VFlag = ((this.regA ^ oper8) & (this.regA ^ res)) > 127;
    }

    private void daa() {
        int suma = 0;
        if ((this.Flags & 0x10) != 0 || (this.regA & 0xF) > 9) {
            suma = 6;
        }
        if (this.carryFlag || this.regA > 153) {
            suma |= 0x60;
        }
        if (this.regA > 153) {
            this.carryFlag = true;
        }
        this.add(suma);
    }

    private int pop() {
        int word = this.MemIoImpl.peek16(this.regSP);
        this.regSP = this.regSP + 2 & 0xFFFF;
        return word;
    }

    private void push(int word) {
        this.regSP = this.regSP - 1 & 0xFFFF;
        this.MemIoImpl.poke8(this.regSP, word >>> 8);
        this.regSP = this.regSP - 1 & 0xFFFF;
        this.MemIoImpl.poke8(this.regSP, word);
    }

    public final boolean isBreakpoint(int address) {
        return this.breakpointAt[address & 0xFFFF];
    }

    public final void setBreakpoint(int address, boolean state) {
        this.breakpointAt[address & 0xFFFF] = state;
    }

    public void resetBreakpoints() {
        Arrays.fill(this.breakpointAt, false);
    }

    private boolean isEI() {
        return (this.regSim & 8) != 0 && !this.pendingEI;
    }

    public final void doTrap() {
        this.activeTRAP = true;
    }

    public final void doInt75() {
        if (this.isEI() && (this.regSim & 4) == 0) {
            this.regSim |= 0x40;
        }
    }

    public final void doInt65() {
        if (this.isEI() && (this.regSim & 2) == 0) {
            this.regSim |= 0x20;
        }
    }

    public final void doInt55() {
        if (this.isEI() && (this.regSim & 1) == 0) {
            this.regSim |= 0x10;
        }
    }

    private void trap() {
        this.clock.addTstates(1);
        if (this.halted) {
            this.halted = false;
            this.regPC = this.regPC + 1 & 0xFFFF;
        }
        this.regSim &= 0xFFFFFFF7;
        this.push(this.regPC);
        this.memptr = 36;
        this.regPC = 36;
    }

    private void int75() {
        if (this.halted) {
            this.halted = false;
            this.regPC = this.regPC + 1 & 0xFFFF;
        }
        this.clock.addTstates(7);
        this.regSim &= 0xFFFFFFB7;
        this.push(this.regPC);
        this.memptr = 60;
        this.regPC = 60;
    }

    private void int65() {
        if (this.halted) {
            this.halted = false;
            this.regPC = this.regPC + 1 & 0xFFFF;
        }
        this.clock.addTstates(7);
        this.regSim &= 0xFFFFFFD7;
        this.push(this.regPC);
        this.memptr = 52;
        this.regPC = 52;
    }

    private void int55() {
        if (this.halted) {
            this.halted = false;
            this.regPC = this.regPC + 1 & 0xFFFF;
        }
        this.clock.addTstates(7);
        this.regSim &= 0xFFFFFFE7;
        this.push(this.regPC);
        this.memptr = 44;
        this.regPC = 44;
    }

    private void intr() {
        if (this.halted) {
            this.halted = false;
            this.regPC = this.regPC + 1 & 0xFFFF;
        }
        this.clock.addTstates(7);
        this.regSim &= 0xFFFFFFF7;
        this.intack = true;
    }

    public final void execute(int statesLimit) {
        while (this.clock.getTstates() < statesLimit) {
            if (this.activeTRAP) {
                this.activeTRAP = false;
                this.trap();
                continue;
            }
            if (this.isEI() && (this.regSim & 0x40) != 0) {
                this.int75();
                continue;
            }
            if (this.isEI() && (this.regSim & 0x20) != 0) {
                this.int65();
                continue;
            }
            if (this.isEI() && (this.regSim & 0x10) != 0) {
                this.int55();
                continue;
            }
            if (this.isEI() && this.activeINT) {
                this.intr();
            }
            if (this.breakpointAt[this.regPC] && !this.intack) {
                this.opCode = this.NotifyImpl.atAddress(this.regPC, this.opCode);
            }
            if (this.astart && this.regPC == 61923) {
                this.regPC = 62491;
                this.setRegHL(32768);
                this.MemIoImpl.poke16(this.MemIoImpl.peek16(42), 62514);
                this.astart = false;
            }
            this.opCode = this.MemIoImpl.fetchOpcode(this.regPC);
            if (!this.intack) {
                this.regPC = this.regPC + 1 & 0xFFFF;
            }
            this.decodeOpcode(this.opCode);
            if (this.pendingEI && this.opCode != 251) {
                this.pendingEI = false;
            }
            if (this.execDone) {
                this.NotifyImpl.execDone();
            }
            this.intack = false;
        }
    }

    private void decodeOpcode(int opCode) {
        switch (opCode) {
            case 1: {
                this.setRegBC(this.MemIoImpl.peek16(this.regPC));
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 2: {
                this.MemIoImpl.poke8(this.getRegBC(), this.regA);
                this.memptr = this.regA << 8 | this.regC + 1 & 0xFF;
                break;
            }
            case 3: {
                this.incRegBC();
                break;
            }
            case 4: {
                this.regB = this.inc8(this.regB);
                break;
            }
            case 5: {
                this.regB = this.dec8(this.regB);
                break;
            }
            case 6: {
                this.regB = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 7: {
                this.carryFlag = this.regA > 127;
                this.regA = this.regA << 1 & 0xFF;
                if (!this.carryFlag) break;
                this.regA |= 1;
                break;
            }
            case 8: {
                this.sub16(this.getRegBC());
                break;
            }
            case 9: {
                this.setRegHL(this.add16(this.getRegHL(), this.getRegBC()));
                break;
            }
            case 10: {
                this.memptr = this.getRegBC();
                this.regA = this.MemIoImpl.peek8(this.memptr);
                ++this.memptr;
                break;
            }
            case 11: {
                this.decRegBC();
                break;
            }
            case 12: {
                this.regC = this.inc8(this.regC);
                break;
            }
            case 13: {
                this.regC = this.dec8(this.regC);
                break;
            }
            case 14: {
                this.regC = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 15: {
                this.carryFlag = (this.regA & 1) != 0;
                this.regA >>>= 1;
                if (!this.carryFlag) break;
                this.regA |= 0x80;
                break;
            }
            case 16: {
                int reg16 = this.getRegHL();
                int sign = reg16 & 0x8000;
                this.carryFlag = (reg16 & 1) != 0;
                reg16 = reg16 >> 1 | sign;
                this.setRegHL(reg16 & 0xFFFF);
                break;
            }
            case 17: {
                this.setRegDE(this.MemIoImpl.peek16(this.regPC));
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 18: {
                this.MemIoImpl.poke8(this.getRegDE(), this.regA);
                this.memptr = this.regA << 8 | this.regE + 1 & 0xFF;
                break;
            }
            case 19: {
                this.incRegDE();
                break;
            }
            case 20: {
                this.regD = this.inc8(this.regD);
                break;
            }
            case 21: {
                this.regD = this.dec8(this.regD);
                break;
            }
            case 22: {
                this.regD = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 23: {
                boolean oldCarry = this.carryFlag;
                this.carryFlag = this.regA > 127;
                this.regA = this.regA << 1 & 0xFF;
                if (!oldCarry) break;
                this.regA |= 1;
                break;
            }
            case 24: {
                int reg16 = this.getRegDE();
                reg16 <<= 1;
                if (this.carryFlag) {
                    reg16 |= 1;
                }
                this.carryFlag = (reg16 & 0x10000) != 0;
                this.setRegDE(reg16 & 0xFFFF);
                break;
            }
            case 25: {
                this.setRegHL(this.add16(this.getRegHL(), this.getRegDE()));
                break;
            }
            case 26: {
                this.memptr = this.getRegDE();
                this.regA = this.MemIoImpl.peek8(this.memptr);
                ++this.memptr;
                break;
            }
            case 27: {
                this.decRegDE();
                break;
            }
            case 28: {
                this.regE = this.inc8(this.regE);
                break;
            }
            case 29: {
                this.regE = this.dec8(this.regE);
                break;
            }
            case 30: {
                this.regE = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 31: {
                boolean oldCarry = this.carryFlag;
                this.carryFlag = (this.regA & 1) != 0;
                this.regA >>>= 1;
                if (!oldCarry) break;
                this.regA |= 0x80;
                break;
            }
            case 32: {
                this.regA = this.MemIoImpl.inSerial() ? this.regSim | 0x80 : this.regSim & 0x7F;
                break;
            }
            case 33: {
                this.setRegHL(this.MemIoImpl.peek16(this.regPC));
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 34: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke16(this.memptr, this.getRegHL());
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 35: {
                this.incRegHL();
                break;
            }
            case 36: {
                this.regH = this.inc8(this.regH);
                break;
            }
            case 37: {
                this.regH = this.dec8(this.regH);
                break;
            }
            case 38: {
                this.regH = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 39: {
                this.daa();
                break;
            }
            case 40: {
                int reg16 = this.MemIoImpl.peek8(this.regPC) & 0xFF;
                this.regPC = this.regPC + 1 & 0xFFFF;
                this.setRegDE(this.getRegHL() + reg16 & 0xFFFF);
                break;
            }
            case 41: {
                int work16 = this.getRegHL();
                this.setRegHL(this.add16(work16, work16));
                break;
            }
            case 42: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.setRegHL(this.MemIoImpl.peek16(this.memptr));
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 43: {
                this.decRegHL();
                break;
            }
            case 44: {
                this.regL = this.inc8(this.regL);
                break;
            }
            case 45: {
                this.regL = this.dec8(this.regL);
                break;
            }
            case 46: {
                this.regL = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 47: {
                this.regA ^= 0xFF;
                break;
            }
            case 48: {
                int reg8 = this.MemIoImpl.peek8(this.regPC);
                if ((reg8 & 8) != 0) {
                    this.regSim = this.regSim & 0xF8 | reg8 & 7;
                }
                if ((reg8 & 0x40) == 0) break;
                this.regSim = this.regSim & 0x7F | reg8 & 0x80;
                this.MemIoImpl.outSerial((reg8 & 0x80) != 0);
                break;
            }
            case 49: {
                this.regSP = this.MemIoImpl.peek16(this.regPC);
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 50: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.MemIoImpl.poke8(this.memptr, this.regA);
                this.memptr = this.regA << 8 | this.memptr + 1 & 0xFF;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 51: {
                this.incRegSP();
                break;
            }
            case 52: {
                int work16 = this.getRegHL();
                int work8 = this.inc8(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 53: {
                int work16 = this.getRegHL();
                int work8 = this.dec8(this.MemIoImpl.peek8(work16));
                this.MemIoImpl.poke8(work16, work8);
                break;
            }
            case 54: {
                this.MemIoImpl.poke8(this.getRegHL(), this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 55: {
                this.carryFlag = true;
                break;
            }
            case 56: {
                int reg16 = this.MemIoImpl.peek8(this.regPC) & 0xFF;
                this.regPC = this.regPC + 1 & 0xFFFF;
                this.setRegDE(this.getRegSP() + reg16 & 0xFFFF);
                break;
            }
            case 57: {
                this.setRegHL(this.add16(this.getRegHL(), this.regSP));
                break;
            }
            case 58: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.regA = this.MemIoImpl.peek8(this.memptr);
                ++this.memptr;
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 59: {
                this.decRegSP();
                break;
            }
            case 60: {
                this.regA = this.inc8(this.regA);
                break;
            }
            case 61: {
                this.regA = this.dec8(this.regA);
                break;
            }
            case 62: {
                this.regA = this.MemIoImpl.peek8(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 63: {
                this.carryFlag = !this.carryFlag;
                break;
            }
            case 65: {
                this.regB = this.regC;
                break;
            }
            case 66: {
                this.regB = this.regD;
                break;
            }
            case 67: {
                this.regB = this.regE;
                break;
            }
            case 68: {
                this.regB = this.regH;
                break;
            }
            case 69: {
                this.regB = this.regL;
                break;
            }
            case 70: {
                this.regB = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 71: {
                this.regB = this.regA;
                break;
            }
            case 72: {
                this.regC = this.regB;
                break;
            }
            case 74: {
                this.regC = this.regD;
                break;
            }
            case 75: {
                this.regC = this.regE;
                break;
            }
            case 76: {
                this.regC = this.regH;
                break;
            }
            case 77: {
                this.regC = this.regL;
                break;
            }
            case 78: {
                this.regC = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 79: {
                this.regC = this.regA;
                break;
            }
            case 80: {
                this.regD = this.regB;
                break;
            }
            case 81: {
                this.regD = this.regC;
                break;
            }
            case 83: {
                this.regD = this.regE;
                break;
            }
            case 84: {
                this.regD = this.regH;
                break;
            }
            case 85: {
                this.regD = this.regL;
                break;
            }
            case 86: {
                this.regD = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 87: {
                this.regD = this.regA;
                break;
            }
            case 88: {
                this.regE = this.regB;
                break;
            }
            case 89: {
                this.regE = this.regC;
                break;
            }
            case 90: {
                this.regE = this.regD;
                break;
            }
            case 92: {
                this.regE = this.regH;
                break;
            }
            case 93: {
                this.regE = this.regL;
                break;
            }
            case 94: {
                this.regE = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 95: {
                this.regE = this.regA;
                break;
            }
            case 96: {
                this.regH = this.regB;
                break;
            }
            case 97: {
                this.regH = this.regC;
                break;
            }
            case 98: {
                this.regH = this.regD;
                break;
            }
            case 99: {
                this.regH = this.regE;
                break;
            }
            case 101: {
                this.regH = this.regL;
                break;
            }
            case 102: {
                this.regH = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 103: {
                this.regH = this.regA;
                break;
            }
            case 104: {
                this.regL = this.regB;
                break;
            }
            case 105: {
                this.regL = this.regC;
                break;
            }
            case 106: {
                this.regL = this.regD;
                break;
            }
            case 107: {
                this.regL = this.regE;
                break;
            }
            case 108: {
                this.regL = this.regH;
                break;
            }
            case 110: {
                this.regL = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 111: {
                this.regL = this.regA;
                break;
            }
            case 112: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regB);
                break;
            }
            case 113: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regC);
                break;
            }
            case 114: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regD);
                break;
            }
            case 115: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regE);
                break;
            }
            case 116: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regH);
                break;
            }
            case 117: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regL);
                break;
            }
            case 118: {
                this.regPC = this.regPC - 1 & 0xFFFF;
                this.halted = true;
                break;
            }
            case 119: {
                this.MemIoImpl.poke8(this.getRegHL(), this.regA);
                break;
            }
            case 120: {
                this.regA = this.regB;
                break;
            }
            case 121: {
                this.regA = this.regC;
                break;
            }
            case 122: {
                this.regA = this.regD;
                break;
            }
            case 123: {
                this.regA = this.regE;
                break;
            }
            case 124: {
                this.regA = this.regH;
                break;
            }
            case 125: {
                this.regA = this.regL;
                break;
            }
            case 126: {
                this.regA = this.MemIoImpl.peek8(this.getRegHL());
                break;
            }
            case 128: {
                this.add(this.regB);
                break;
            }
            case 129: {
                this.add(this.regC);
                break;
            }
            case 130: {
                this.add(this.regD);
                break;
            }
            case 131: {
                this.add(this.regE);
                break;
            }
            case 132: {
                this.add(this.regH);
                break;
            }
            case 133: {
                this.add(this.regL);
                break;
            }
            case 134: {
                this.add(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 135: {
                this.add(this.regA);
                break;
            }
            case 136: {
                this.adc(this.regB);
                break;
            }
            case 137: {
                this.adc(this.regC);
                break;
            }
            case 138: {
                this.adc(this.regD);
                break;
            }
            case 139: {
                this.adc(this.regE);
                break;
            }
            case 140: {
                this.adc(this.regH);
                break;
            }
            case 141: {
                this.adc(this.regL);
                break;
            }
            case 142: {
                this.adc(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 143: {
                this.adc(this.regA);
                break;
            }
            case 144: {
                this.sub(this.regB);
                break;
            }
            case 145: {
                this.sub(this.regC);
                break;
            }
            case 146: {
                this.sub(this.regD);
                break;
            }
            case 147: {
                this.sub(this.regE);
                break;
            }
            case 148: {
                this.sub(this.regH);
                break;
            }
            case 149: {
                this.sub(this.regL);
                break;
            }
            case 150: {
                this.sub(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 151: {
                this.sub(this.regA);
                break;
            }
            case 152: {
                this.sbc(this.regB);
                break;
            }
            case 153: {
                this.sbc(this.regC);
                break;
            }
            case 154: {
                this.sbc(this.regD);
                break;
            }
            case 155: {
                this.sbc(this.regE);
                break;
            }
            case 156: {
                this.sbc(this.regH);
                break;
            }
            case 157: {
                this.sbc(this.regL);
                break;
            }
            case 158: {
                this.sbc(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 159: {
                this.sbc(this.regA);
                break;
            }
            case 160: {
                this.and(this.regB);
                break;
            }
            case 161: {
                this.and(this.regC);
                break;
            }
            case 162: {
                this.and(this.regD);
                break;
            }
            case 163: {
                this.and(this.regE);
                break;
            }
            case 164: {
                this.and(this.regH);
                break;
            }
            case 165: {
                this.and(this.regL);
                break;
            }
            case 166: {
                this.and(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 167: {
                this.and(this.regA);
                break;
            }
            case 168: {
                this.xor(this.regB);
                break;
            }
            case 169: {
                this.xor(this.regC);
                break;
            }
            case 170: {
                this.xor(this.regD);
                break;
            }
            case 171: {
                this.xor(this.regE);
                break;
            }
            case 172: {
                this.xor(this.regH);
                break;
            }
            case 173: {
                this.xor(this.regL);
                break;
            }
            case 174: {
                this.xor(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 175: {
                this.xor(this.regA);
                break;
            }
            case 176: {
                this.or(this.regB);
                break;
            }
            case 177: {
                this.or(this.regC);
                break;
            }
            case 178: {
                this.or(this.regD);
                break;
            }
            case 179: {
                this.or(this.regE);
                break;
            }
            case 180: {
                this.or(this.regH);
                break;
            }
            case 181: {
                this.or(this.regL);
                break;
            }
            case 182: {
                this.or(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 183: {
                this.or(this.regA);
                break;
            }
            case 184: {
                this.cp(this.regB);
                break;
            }
            case 185: {
                this.cp(this.regC);
                break;
            }
            case 186: {
                this.cp(this.regD);
                break;
            }
            case 187: {
                this.cp(this.regE);
                break;
            }
            case 188: {
                this.cp(this.regH);
                break;
            }
            case 189: {
                this.cp(this.regL);
                break;
            }
            case 190: {
                this.cp(this.MemIoImpl.peek8(this.getRegHL()));
                break;
            }
            case 191: {
                this.cp(this.regA);
                break;
            }
            case 192: {
                if ((this.Flags & 0x40) != 0) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 193: {
                this.setRegBC(this.pop());
                break;
            }
            case 194: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.Flags & 0x40) == 0) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 195: {
                this.memptr = this.regPC = this.MemIoImpl.peek16(this.regPC);
                break;
            }
            case 196: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.Flags & 0x40) == 0) {
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 197: {
                this.push(this.getRegBC());
                break;
            }
            case 198: {
                this.add(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 199: {
                this.push(this.regPC);
                this.memptr = 0;
                this.regPC = 0;
                break;
            }
            case 200: {
                if ((this.Flags & 0x40) == 0) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 201: {
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 202: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.Flags & 0x40) != 0) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 203: {
                if (!this.VFlag) break;
                this.push(this.regPC);
                this.memptr = 64;
                this.regPC = 64;
                break;
            }
            case 204: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.Flags & 0x40) != 0) {
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 205: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                this.push(this.regPC + 2);
                this.regPC = this.memptr;
                break;
            }
            case 206: {
                this.adc(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 207: {
                this.push(this.regPC);
                this.memptr = 8;
                this.regPC = 8;
                break;
            }
            case 208: {
                if (this.carryFlag) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 209: {
                this.setRegDE(this.pop());
                break;
            }
            case 210: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (!this.carryFlag) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 211: {
                int work8 = this.MemIoImpl.peek8(this.regPC);
                this.memptr = this.regA << 8;
                this.MemIoImpl.outPort(this.memptr | work8, this.regA);
                this.memptr |= work8 + 1 & 0xFF;
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 212: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (!this.carryFlag) {
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 213: {
                this.push(this.getRegDE());
                break;
            }
            case 214: {
                this.sub(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 215: {
                this.push(this.regPC);
                this.memptr = 16;
                this.regPC = 16;
                break;
            }
            case 216: {
                if (!this.carryFlag) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 217: {
                this.memptr = this.getRegDE();
                this.MemIoImpl.poke16(this.memptr, this.getRegHL());
                ++this.memptr;
                break;
            }
            case 218: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.carryFlag) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 219: {
                this.memptr = this.regA << 8 | this.MemIoImpl.peek8(this.regPC);
                this.regA = this.MemIoImpl.inPort(this.memptr);
                ++this.memptr;
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 220: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.carryFlag) {
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 221: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (!this.UFlag) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 222: {
                this.sbc(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 223: {
                this.push(this.regPC);
                this.memptr = 24;
                this.regPC = 24;
                break;
            }
            case 224: {
                if ((this.Flags & 4) != 0) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 225: {
                this.setRegHL(this.pop());
                break;
            }
            case 226: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.Flags & 4) == 0) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 227: {
                int work16 = this.regH;
                int work8 = this.regL;
                this.setRegHL(this.MemIoImpl.peek16(this.regSP));
                this.MemIoImpl.poke8(this.regSP + 1 & 0xFFFF, work16);
                this.MemIoImpl.poke8(this.regSP, work8);
                this.memptr = this.getRegHL();
                break;
            }
            case 228: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.Flags & 4) == 0) {
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 229: {
                this.push(this.getRegHL());
                break;
            }
            case 230: {
                this.and(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 231: {
                this.push(this.regPC);
                this.memptr = 32;
                this.regPC = 32;
                break;
            }
            case 232: {
                if ((this.Flags & 4) == 0) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 233: {
                this.regPC = this.getRegHL();
                break;
            }
            case 234: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.Flags & 4) != 0) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 235: {
                int work8 = this.regH;
                this.regH = this.regD;
                this.regD = work8;
                work8 = this.regL;
                this.regL = this.regE;
                this.regE = work8;
                break;
            }
            case 236: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if ((this.Flags & 4) != 0) {
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 237: {
                this.memptr = this.getRegDE();
                this.setRegHL(this.MemIoImpl.peek16(this.memptr));
                ++this.memptr;
                break;
            }
            case 238: {
                this.xor(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 239: {
                this.push(this.regPC);
                this.memptr = 40;
                this.regPC = 40;
                break;
            }
            case 240: {
                if (this.Flags >= 128) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 241: {
                this.setRegAF(this.pop());
                break;
            }
            case 242: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.Flags < 128) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 243: {
                this.regSim &= 0xFFFFFFF7;
                break;
            }
            case 244: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.Flags < 128) {
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 245: {
                this.push(this.getRegAF());
                break;
            }
            case 246: {
                this.or(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 247: {
                this.push(this.regPC);
                this.memptr = 48;
                this.regPC = 48;
                break;
            }
            case 248: {
                if (this.Flags <= 127) break;
                this.regPC = this.memptr = this.pop();
                break;
            }
            case 249: {
                this.regSP = this.getRegHL();
                break;
            }
            case 250: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.Flags > 127) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 251: {
                this.regSim |= 8;
                this.pendingEI = true;
                break;
            }
            case 252: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.Flags > 127) {
                    this.push(this.regPC + 2);
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 253: {
                this.memptr = this.MemIoImpl.peek16(this.regPC);
                if (this.UFlag) {
                    this.regPC = this.memptr;
                    break;
                }
                this.regPC = this.regPC + 2 & 0xFFFF;
                break;
            }
            case 254: {
                this.cp(this.MemIoImpl.peek8(this.regPC));
                this.regPC = this.regPC + 1 & 0xFFFF;
                break;
            }
            case 255: {
                this.push(this.regPC);
                this.memptr = 56;
                this.regPC = 56;
            }
        }
    }

    static {
        for (int idx = 0; idx < 256; ++idx) {
            if (idx > 127) {
                int n = idx;
                fl[n] = fl[n] | 0x80;
            }
            boolean evenBits = true;
            for (int mask = 1; mask < 256; mask <<= 1) {
                if ((idx & mask) == 0) continue;
                evenBits = !evenBits;
            }
            if (!evenBits) continue;
            int n = idx;
            fl[n] = fl[n] | 4;
        }
        fl[0] = fl[0] | 0x40;
    }
}

