/*
 * Decompiled with CFR 0.152.
 */
package machine;

import gui.JIQScreen;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import machine.Clock;
import machine.Config;
import machine.Grafik;
import machine.I8085;
import machine.IqTimer;
import machine.Keyboard;
import machine.MemIoOps;
import machine.Memory;
import machine.NotifyOps;
import machine.Pic;
import machine.Pio8255;
import machine.Pio8255Notify;
import machine.Tape;

public class Iq
extends Thread
implements MemIoOps,
NotifyOps,
Pio8255Notify {
    private JIQScreen scr;
    private BufferedImage img;
    private int c0 = 0;
    private int c1 = 0xFFFFFF;
    int col0;
    int col1;
    int sirka = 560;
    int vyska = 272;
    int ofsx = 20;
    int ofsy = 8;
    private byte[] chars;
    private byte[][] vm;
    private Config cfg;
    private Keyboard key;
    private Memory mem;
    private Timer tim;
    private IqTimer task;
    public Clock clk;
    private I8085 cpu;
    private Pic ic;
    private Pio8255 pio;
    private Tape tap;
    private Grafik graf;
    private boolean paused;
    private int port80;
    private boolean khz1;
    private boolean zobrgr;
    private boolean tapein;
    private boolean tapeo;
    private boolean tapeout;
    private boolean tapestart = false;
    private boolean tapeinv = true;
    private final int[] vm64 = new int[2048];
    private final int[] znsada = new int[1024];
    private final int[] znsadainv = new int[1024];
    private final int[] dstg = new int[1024];
    private final int[] dstg64 = new int[2048];

    public Iq() {
        this.img = new BufferedImage(this.sirka, this.vyska, 1);
        this.cfg = new Config();
        this.mem = new Memory(this.cfg);
        this.chars = this.mem.getChars();
        this.vm = this.mem.getVRam();
        this.tim = new Timer("IQclock");
        this.clk = new Clock();
        this.cpu = new I8085(this.clk, this, this);
        this.ic = new Pic();
        this.ic.setCPU(this.cpu);
        this.pio = new Pio8255(this);
        this.key = new Keyboard();
        this.key.setMachine(this);
        this.key.setPic(this.ic);
        this.graf = new Grafik();
        this.graf.Init();
        this.tap = new Tape(this);
        this.paused = true;
        this.Reset(true);
    }

    public void setConfig(Config c) {
        if (!this.cfg.equals(c)) {
            this.cfg = c;
            this.Reset(false);
        }
    }

    public Config getConfig() {
        return this.cfg;
    }

    public void setScreen(JIQScreen screen) {
        this.scr = screen;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public Keyboard getKeyboard() {
        return this.key;
    }

    public void clearScreen() {
        if (this.cfg.Inverz) {
            this.col1 = this.c0;
            this.col0 = this.c1;
        } else {
            this.col1 = this.c1;
            this.col0 = this.c0;
        }
        for (int i = 0; i < this.vyska; ++i) {
            for (int j = 0; j < this.sirka; ++j) {
                this.img.setRGB(j, i, this.col0);
            }
        }
    }

    public final void Reset(boolean dirty) {
        if (this.cfg.Inverz) {
            this.col1 = this.c0;
            this.col0 = this.c1;
        } else {
            this.col1 = this.c1;
            this.col0 = this.c0;
        }
        this.mem.Reset(dirty);
        this.port80 = 0;
        this.mem.setBootstrap(true);
        this.clk.reset();
        this.ic.Reset();
        this.cpu.reset();
        this.pio.Reset();
        this.key.Reset();
        this.cpu.astart = this.cfg.AmosAS && this.cfg.getMain() == this.cfg.AMOS;
        for (int i = 0; i < 1024; ++i) {
            this.znsada[i] = this.chars[i] & 0xFF;
            this.znsadainv[i] = 255 - this.znsada[i];
            this.dstg[i] = 2 * (i & 0x1F) + (i >> 5) * 512;
            this.dstg64[i] = (i & 0x3F) + (i >> 6) * 512;
            this.dstg64[i + 1024] = this.dstg64[i] + 8192;
        }
    }

    public synchronized void startEmulation() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.task = new IqTimer(this);
        this.tim.scheduleAtFixedRate((TimerTask)this.task, 100L, 20L);
    }

    public synchronized void stopEmulation() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.task.cancel();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void ms20() {
        int b;
        if (this.paused) {
            return;
        }
        this.ic.assertInt(6);
        for (int t = 0; t < 40; ++t) {
            this.cpu.execute(this.clk.getTstates() + 1024);
            boolean bl = this.khz1 = !this.khz1;
            if (!this.khz1) continue;
            this.tapeout = this.tapeo;
        }
        boolean bl = this.zobrgr = this.graf.Enabled && this.graf.ShowGR && this.cfg.grafik;
        if (this.cfg.Inverz) {
            this.col1 = this.c0;
            this.col0 = this.c1;
        } else {
            this.col1 = this.c1;
            this.col0 = this.c0;
        }
        byte by = this.cfg.getVideo();
        this.cfg.getClass();
        if (by == 0) {
            for (int ad = 0; ad < 1024; ++ad) {
                boolean inver;
                b = this.vm[0][ad] & 0xFF;
                if (b > 127) {
                    inver = true;
                    b &= 0x7F;
                } else {
                    inver = false;
                }
                this.vlozdovram32(ad, b * 8, inver);
            }
        } else {
            boolean druhy = false;
            for (int ad = 0; ad < 256; ++ad) {
                this.vm64[ad] = this.vm[0][ad] & 0xFF;
                this.vm64[ad + 256] = this.vm[0][ad + 256] & 0xFF;
                this.vm64[ad + 512] = this.vm[0][ad + 512] & 0xFF;
                this.vm64[ad + 768] = this.vm[0][ad + 768] & 0xFF;
                this.vm64[ad + 1024] = this.vm[1][ad] & 0xFF;
                this.vm64[ad + 1280] = this.vm[1][ad + 256] & 0xFF;
                this.vm64[ad + 1536] = this.vm[1][ad + 512] & 0xFF;
                this.vm64[ad + 1792] = this.vm[1][ad + 768] & 0xFF;
            }
            boolean zdvoj = false;
            for (int ad = 0; ad < 2048; ++ad) {
                boolean inver;
                if ((ad & 0x3F) == 0) {
                    zdvoj = false;
                }
                if ((b = this.vm64[ad]) > 127) {
                    b &= 0x7F;
                    inver = true;
                } else {
                    inver = false;
                }
                if (b == 127) {
                    b = 32;
                }
                if (b == 124) {
                    b = 32;
                }
                if (!zdvoj) {
                    this.vlozdovram64(ad, b * 8, inver);
                } else if (!druhy) {
                    int aa = this.vm64[ad - 1];
                    if ((aa & 0x7F) == 127) {
                        aa = this.vm64[ad];
                    }
                    if (aa > 127) {
                        aa &= 0x7F;
                        inver = true;
                    } else {
                        inver = false;
                    }
                    if (aa == 124 || aa == 13) {
                        zdvoj = false;
                        this.vlozdovram64(ad, 256, inver);
                    } else {
                        this.vlozdovram64zdv(ad, aa * 8, inver);
                        druhy = true;
                    }
                } else {
                    druhy = false;
                }
                b = this.vm64[ad] & 0x7F;
                if (b != 127) continue;
                zdvoj = this.cfg.V64ena32;
                if ((ad & 1) != 1) continue;
                druhy = true;
                this.vlozdovram64zdv(ad, 256, inver);
            }
        }
        this.scr.repaint();
    }

    private void vlozdovram32(int adl, int src, boolean inverl) {
        int dst = this.dstg[adl];
        int b = (adl >> 5) * 8 + this.ofsy;
        for (int ii = 0; ii < 8; ++ii) {
            int a = (adl & 0x1F) * 16 + this.ofsx;
            int c = inverl ? this.znsadainv[src++] : this.znsada[src++];
            if ((c & 0x80) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x40) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x20) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x10) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 8) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 4) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 2) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 1) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a, b, this.col1);
            }
            a = (adl & 0x1F) * 16 + this.ofsx;
            if (this.zobrgr) {
                if (((c = this.graf.GVRam[dst++]) & 0x80) == 128) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x40) == 64) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x20) == 32) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x10) == 16) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 8) == 8) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 4) == 4) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 2) == 2) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 1) == 1) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                c = this.graf.GVRam[dst];
                if ((c & 0x80) == 128) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x40) == 64) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x20) == 32) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x10) == 16) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 8) == 8) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 4) == 4) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 2) == 2) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 1) == 1) {
                    this.img.setRGB(a, b, this.col1);
                }
                dst += 63;
            }
            ++b;
        }
    }

    private void vlozdovram64zdv(int adl, int src, boolean inverl) {
        int dst = this.dstg64[adl];
        int b = (adl >> 6) * 8 + this.ofsy;
        for (int ii = 0; ii < 8; ++ii) {
            int a = (adl & 0x3F) * 8 + this.ofsx;
            int c = inverl ? this.znsadainv[src++] : this.znsada[src++];
            if ((c & 0x80) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x40) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x20) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x10) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 8) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 4) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 2) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 1) == 0) {
                this.img.setRGB(a++, b, this.col0);
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
                this.img.setRGB(a, b, this.col1);
            }
            a = (adl & 0x3F) * 8 + this.ofsx;
            if (this.zobrgr) {
                if (((c = this.graf.GVRam[dst++]) & 0x80) == 128) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x40) == 64) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x20) == 32) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x10) == 16) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 8) == 8) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 4) == 4) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 2) == 2) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 1) == 1) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((adl & 0x3F) != 63) {
                    c = this.graf.GVRam[dst];
                    if ((c & 0x80) == 128) {
                        this.img.setRGB(a, b, this.col1);
                    }
                    ++a;
                    if ((c & 0x40) == 64) {
                        this.img.setRGB(a, b, this.col1);
                    }
                    ++a;
                    if ((c & 0x20) == 32) {
                        this.img.setRGB(a, b, this.col1);
                    }
                    ++a;
                    if ((c & 0x10) == 16) {
                        this.img.setRGB(a, b, this.col1);
                    }
                    ++a;
                    if ((c & 8) == 8) {
                        this.img.setRGB(a, b, this.col1);
                    }
                    ++a;
                    if ((c & 4) == 4) {
                        this.img.setRGB(a, b, this.col1);
                    }
                    ++a;
                    if ((c & 2) == 2) {
                        this.img.setRGB(a, b, this.col1);
                    }
                    ++a;
                    if ((c & 1) == 1) {
                        this.img.setRGB(a, b, this.col1);
                    }
                }
                dst += 63;
            }
            ++b;
        }
    }

    private void vlozdovram64(int adl, int src, boolean inverl) {
        int dst = this.dstg64[adl];
        int b = (adl >> 6) * 8 + this.ofsy;
        for (int ii = 0; ii < 8; ++ii) {
            int a = (adl & 0x3F) * 8 + this.ofsx;
            int c = inverl ? this.znsadainv[src++] : this.znsada[src++];
            if ((c & 0x80) == 0) {
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x40) == 0) {
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x20) == 0) {
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 0x10) == 0) {
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 8) == 0) {
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 4) == 0) {
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 2) == 0) {
                this.img.setRGB(a++, b, this.col0);
            } else {
                this.img.setRGB(a++, b, this.col1);
            }
            if ((c & 1) == 0) {
                this.img.setRGB(a, b, this.col0);
            } else {
                this.img.setRGB(a, b, this.col1);
            }
            a = (adl & 0x3F) * 8 + this.ofsx;
            if (this.zobrgr) {
                c = this.graf.GVRam[dst];
                if ((c & 0x80) == 128) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x40) == 64) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x20) == 32) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 0x10) == 16) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 8) == 8) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 4) == 4) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 2) == 2) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                if ((c & 1) == 1) {
                    this.img.setRGB(a, b, this.col1);
                }
                ++a;
                dst += 64;
            }
            if ((adl & 0x3F) == 63) {
                for (int kk = 0; kk < 8; ++kk) {
                    this.img.setRGB(a++, b, this.col0);
                }
            }
            ++b;
        }
    }

    @Override
    public void run() {
        this.startEmulation();
        boolean forever = true;
        while (forever) {
            try {
                Iq.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Iq.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public int fetchOpcode(int address) {
        this.clk.addTstates(4);
        if (this.cpu.isIntAck()) {
            return this.ic.getIntAckCycle();
        }
        int opcode = this.mem.readByte(address) & 0xFF;
        return opcode;
    }

    @Override
    public int peek8(int address) {
        this.clk.addTstates(3);
        int value = this.mem.readByte(address) & 0xFF;
        return value;
    }

    @Override
    public void poke8(int address, int value) {
        this.clk.addTstates(3);
        this.mem.writeByte(address, (byte)value);
    }

    @Override
    public int peek16(int address) {
        this.clk.addTstates(6);
        if (this.cpu.isIntAck()) {
            this.cpu.setRegPC(this.cpu.getRegPC() - 2 & 0xFFFF);
            return this.ic.getIntAckCycle();
        }
        int lsb = this.mem.readByte(address) & 0xFF;
        address = address + 1 & 0xFFFF;
        return this.mem.readByte(address) << 8 & 0xFF00 | lsb;
    }

    @Override
    public void poke16(int address, int word) {
        this.clk.addTstates(6);
        this.mem.writeByte(address, (byte)word);
        address = address + 1 & 0xFFFF;
        this.mem.writeByte(address, (byte)(word >>> 8));
    }

    @Override
    public int inPort(int port) {
        this.clk.addTstates(4);
        switch (port &= 0xFF) {
            case 132: {
                return this.pio.CpuRead(this.pio.PP_PortA);
            }
            case 133: {
                return this.pio.CpuRead(this.pio.PP_PortB);
            }
            case 134: {
                return this.pio.CpuRead(this.pio.PP_PortC);
            }
            case 135: {
                return this.pio.CpuRead(this.pio.PP_CWR);
            }
            case 136: {
                return this.ic.readPortA0();
            }
            case 137: {
                return this.ic.readPortA1();
            }
            case 212: {
                return this.graf.rpD4();
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                byte by = this.cfg.getVideo();
                this.cfg.getClass();
                if (by == 1) {
                    return 254;
                }
                return 255;
            }
        }
        return 255;
    }

    @Override
    public void outPort(int port, int value) {
        this.clk.addTstates(4);
        switch (port &= 0xFF) {
            case 128: {
                this.port80 = value;
                this.mem.setBootstrap((value & 1) == 0);
                break;
            }
            case 132: {
                this.pio.CpuWrite(this.pio.PP_PortA, value);
                break;
            }
            case 133: {
                this.pio.CpuWrite(this.pio.PP_PortB, value);
                break;
            }
            case 134: {
                this.pio.CpuWrite(this.pio.PP_PortC, value);
                break;
            }
            case 135: {
                this.pio.CpuWrite(this.pio.PP_CWR, value);
                break;
            }
            case 136: {
                this.ic.writePortA0(value);
                break;
            }
            case 137: {
                this.ic.writePortA1(value);
                break;
            }
            case 208: {
                this.graf.D0 = value;
                break;
            }
            case 209: {
                this.graf.D1 = value;
                break;
            }
            case 210: {
                this.graf.wpD2(value);
                break;
            }
            case 211: {
                this.graf.wpD3(value);
                break;
            }
            case 212: {
                this.graf.wpD4(value);
                break;
            }
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                if (this.cfg.getMain() != this.cfg.AMOS) break;
                int aa = value & 3;
                if (aa == 0) {
                    this.mem.setPascal();
                }
                if (aa == 1) {
                    this.mem.setPascal1();
                }
                if (aa == 2) {
                    this.mem.setAssembler();
                }
                if (aa != 3) break;
                this.mem.setAmosNoRom();
                break;
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                byte by = this.cfg.getVideo();
                this.cfg.getClass();
                if (by != 1) break;
                if ((value & 1) == 0) {
                    this.cfg.V64ena32 = false;
                    break;
                }
                this.cfg.V64ena32 = true;
                break;
            }
        }
    }

    @Override
    public int atAddress(int address, int opcode) {
        return opcode;
    }

    @Override
    public boolean inSerial() {
        return false;
    }

    @Override
    public void outSerial(boolean sod) {
    }

    @Override
    public void execDone() {
    }

    @Override
    public void OnCpuWriteA() {
    }

    @Override
    public void OnCpuWriteB() {
    }

    @Override
    public void OnCpuWriteC() {
        if (this.pio == null) {
            return;
        }
        this.tapeo = this.pio.PeripheralReadBit(this.pio.PP_PortC, 0);
        if (this.tapestart != this.pio.PeripheralReadBit(this.pio.PP_PortC, 1)) {
            this.tapestart = this.pio.PeripheralReadBit(this.pio.PP_PortC, 1);
            if (this.tapestart) {
                this.tap.tapeStart();
            } else {
                this.tap.tapeStop();
            }
        }
    }

    @Override
    public void OnCpuWriteCL() {
    }

    @Override
    public void OnCpuWriteCH() {
    }

    @Override
    public void OnCpuWriteCWR(int value) {
    }

    @Override
    public void OnCpuReadA() {
        this.pio.PeripheralWriteByte(this.pio.PP_PortA, this.key.readKeyboardPortA(this.pio.PeripheralReadByte(this.pio.PP_PortB)));
    }

    @Override
    public void OnCpuReadB() {
        this.pio.PeripheralWriteByte(this.pio.PP_PortB, this.key.readKeyboardPortB(this.pio.PeripheralReadByte(this.pio.PP_PortA)));
    }

    @Override
    public void OnCpuReadC() {
    }

    @Override
    public void OnCpuReadCL() {
    }

    @Override
    public void OnCpuReadCH() {
        if (this.tapestart) {
            this.pio.PeripheralChangeBit(this.pio.PP_PortC, 7, this.tapein);
            this.pio.PeripheralChangeBit(this.pio.PP_PortC, 6, false);
            this.pio.PeripheralChangeBit(this.pio.PP_PortC, 5, this.khz1);
            this.pio.PeripheralChangeBit(this.pio.PP_PortC, 4, false);
        } else {
            this.pio.PeripheralChangeBit(this.pio.PP_PortC, 7, !this.key.isFB());
            this.pio.PeripheralChangeBit(this.pio.PP_PortC, 6, !this.key.isFA());
            this.pio.PeripheralChangeBit(this.pio.PP_PortC, 5, !this.key.isCtrl());
            this.pio.PeripheralChangeBit(this.pio.PP_PortC, 4, !this.key.isShift());
        }
    }

    void setTapeIn(boolean readSample) {
        this.tapein = readSample ^ this.tapeinv;
    }

    boolean getTapeOut() {
        return this.tapeout ^ this.khz1;
    }

    public void openLoadTape(String canonicalPath) {
        this.tap.openLoadTape(canonicalPath);
    }

    public void openSaveTape(String canonicalPath) {
        this.tap.openSaveTape(canonicalPath);
    }

    public void setTapeMode(boolean record) {
        this.tap.setTapeMode(record);
    }

    public void shutdownCleanup() {
        this.tap.closeCleanup();
    }

    public void setTapeInvert(boolean inverted) {
        this.tapeinv = inverted;
    }
}

