/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import machine.Iq;
import machine.Pic;

public final class Keyboard
implements KeyListener {
    private int[] row = new int[8];
    private boolean shift;
    private boolean ctrl;
    private boolean fa;
    private boolean fb;
    private Pic ic;
    private Iq machine;
    private final int sb0 = 1;
    private final int sb1 = 2;
    private final int sb2 = 4;
    private final int sb3 = 8;
    private final int sb4 = 16;
    private final int sb5 = 32;
    private final int sb6 = 64;
    private final int sb7 = 128;
    private final int rb0 = -2;
    private final int rb1 = -3;
    private final int rb2 = -5;
    private final int rb3 = -9;
    private final int rb4 = -17;
    private final int rb5 = -33;
    private final int rb6 = -65;
    private final int rb7 = -129;

    public Keyboard() {
        this.Reset();
    }

    public void Reset() {
        this.row[0] = 255;
        this.row[1] = 255;
        this.row[2] = 255;
        this.row[3] = 255;
        this.row[4] = 255;
        this.row[5] = 255;
        this.row[6] = 255;
        this.row[7] = 255;
        this.shift = false;
        this.ctrl = false;
        this.fa = false;
        this.fb = false;
    }

    public void setPic(Pic pic) {
        this.ic = pic;
    }

    public void setMachine(Iq m) {
        this.machine = m;
    }

    public int readKeyboardPortA(int port) {
        int keys = 255;
        int i = 0;
        int mask = 1;
        while (i < 8) {
            if ((port & mask) == 0) {
                keys &= this.row[i];
            }
            ++i;
            mask <<= 1;
        }
        return keys;
    }

    public int readKeyboardPortB(int port) {
        int keys = 255;
        int i = 0;
        int mask = 1;
        while (i < 8) {
            if ((this.row[i] | port) != 255) {
                keys &= mask ^ 0xFF;
            }
            ++i;
            mask <<= 1;
        }
        return keys;
    }

    public boolean isShift() {
        return this.shift;
    }

    public boolean isCtrl() {
        return this.ctrl;
    }

    public boolean isFA() {
        return this.fa;
    }

    public boolean isFB() {
        return this.fb;
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 118: {
                this.machine.Reset(false);
                break;
            }
            case 117: {
                this.ic.assertInt(5);
                break;
            }
            case 16: {
                this.shift = true;
                break;
            }
            case 17: {
                this.ctrl = true;
                break;
            }
            case 18: {
                this.fa = true;
                break;
            }
            case 65406: {
                this.fb = true;
                break;
            }
            case 49: {
                this.row[0] = this.row[0] & 0xFFFFFFFE;
                break;
            }
            case 50: {
                this.row[0] = this.row[0] & 0xFFFFFFFD;
                break;
            }
            case 51: {
                this.row[0] = this.row[0] & 0xFFFFFFFB;
                break;
            }
            case 52: {
                this.row[0] = this.row[0] & 0xFFFFFFF7;
                break;
            }
            case 53: {
                this.row[0] = this.row[0] & 0xFFFFFFEF;
                break;
            }
            case 54: {
                this.row[0] = this.row[0] & 0xFFFFFFDF;
                break;
            }
            case 55: {
                this.row[0] = this.row[0] & 0xFFFFFFBF;
                break;
            }
            case 56: {
                this.row[0] = this.row[0] & 0xFFFFFF7F;
                break;
            }
            case 81: {
                this.row[1] = this.row[1] & 0xFFFFFFFE;
                break;
            }
            case 87: {
                this.row[1] = this.row[1] & 0xFFFFFFFD;
                break;
            }
            case 69: {
                this.row[1] = this.row[1] & 0xFFFFFFFB;
                break;
            }
            case 82: {
                this.row[1] = this.row[1] & 0xFFFFFFF7;
                break;
            }
            case 84: {
                this.row[1] = this.row[1] & 0xFFFFFFEF;
                break;
            }
            case 89: {
                this.row[1] = this.row[1] & 0xFFFFFFDF;
                break;
            }
            case 85: {
                this.row[1] = this.row[1] & 0xFFFFFFBF;
                break;
            }
            case 73: {
                this.row[1] = this.row[1] & 0xFFFFFF7F;
                break;
            }
            case 65: {
                this.row[2] = this.row[2] & 0xFFFFFFFE;
                break;
            }
            case 83: {
                this.row[2] = this.row[2] & 0xFFFFFFFD;
                break;
            }
            case 68: {
                this.row[2] = this.row[2] & 0xFFFFFFFB;
                break;
            }
            case 70: {
                this.row[2] = this.row[2] & 0xFFFFFFF7;
                break;
            }
            case 71: {
                this.row[2] = this.row[2] & 0xFFFFFFEF;
                break;
            }
            case 72: {
                this.row[2] = this.row[2] & 0xFFFFFFDF;
                break;
            }
            case 74: {
                this.row[2] = this.row[2] & 0xFFFFFFBF;
                break;
            }
            case 75: {
                this.row[2] = this.row[2] & 0xFFFFFF7F;
                break;
            }
            case 90: {
                this.row[3] = this.row[3] & 0xFFFFFFFE;
                break;
            }
            case 88: {
                this.row[3] = this.row[3] & 0xFFFFFFFD;
                break;
            }
            case 67: {
                this.row[3] = this.row[3] & 0xFFFFFFFB;
                break;
            }
            case 86: {
                this.row[3] = this.row[3] & 0xFFFFFFF7;
                break;
            }
            case 66: {
                this.row[3] = this.row[3] & 0xFFFFFFEF;
                break;
            }
            case 78: {
                this.row[3] = this.row[3] & 0xFFFFFFDF;
                break;
            }
            case 77: {
                this.row[3] = this.row[3] & 0xFFFFFFBF;
                break;
            }
            case 44: {
                this.row[3] = this.row[3] & 0xFFFFFF7F;
                break;
            }
            case 57: {
                this.row[4] = this.row[4] & 0xFFFFFFFE;
                break;
            }
            case 79: {
                this.row[4] = this.row[4] & 0xFFFFFFFD;
                break;
            }
            case 76: {
                this.row[4] = this.row[4] & 0xFFFFFFFB;
                break;
            }
            case 46: {
                this.row[4] = this.row[4] & 0xFFFFFFF7;
                break;
            }
            case 10: {
                this.row[4] = this.row[4] & 0xFFFFFFEF;
                break;
            }
            case 127: {
                this.row[4] = this.row[4] & 0xFFFFFFDF;
                break;
            }
            case 155: {
                this.row[4] = this.row[4] & 0xFFFFFFBF;
                break;
            }
            case 112: {
                this.row[4] = this.row[4] & 0xFFFFFF7F;
                break;
            }
            case 48: {
                this.row[5] = this.row[5] & 0xFFFFFFFE;
                break;
            }
            case 80: {
                this.row[5] = this.row[5] & 0xFFFFFFFD;
                break;
            }
            case 59: {
                this.row[5] = this.row[5] & 0xFFFFFFFB;
                break;
            }
            case 47: {
                this.row[5] = this.row[5] & 0xFFFFFFF7;
                break;
            }
            case 92: {
                this.row[5] = this.row[5] & 0xFFFFFFEF;
                break;
            }
            case 34: {
                this.row[5] = this.row[5] & 0xFFFFFFDF;
                break;
            }
            case 37: {
                this.row[5] = this.row[5] & 0xFFFFFFBF;
                break;
            }
            case 113: {
                this.row[5] = this.row[5] & 0xFFFFFF7F;
                break;
            }
            case 61: {
                this.row[6] = this.row[6] & 0xFFFFFFFE;
                break;
            }
            case 91: {
                this.row[6] = this.row[6] & 0xFFFFFFFD;
                break;
            }
            case 93: {
                this.row[6] = this.row[6] & 0xFFFFFFFB;
                break;
            }
            case 40: {
                this.row[6] = this.row[6] & 0xFFFFFFF7;
                break;
            }
            case 116: {
                this.row[6] = this.row[6] & 0xFFFFFFEF;
                break;
            }
            case 33: {
                this.row[6] = this.row[6] & 0xFFFFFFDF;
                break;
            }
            case 36: {
                this.row[6] = this.row[6] & 0xFFFFFFBF;
                break;
            }
            case 115: {
                this.row[6] = this.row[6] & 0xFFFFFF7F;
                break;
            }
            case 45: {
                this.row[7] = this.row[7] & 0xFFFFFFFE;
                break;
            }
            case 192: {
                this.row[7] = this.row[7] & 0xFFFFFFFD;
                break;
            }
            case 222: {
                this.row[7] = this.row[7] & 0xFFFFFFFB;
                break;
            }
            case 32: {
                this.row[7] = this.row[7] & 0xFFFFFFF7;
                break;
            }
            case 523: {
                this.row[7] = this.row[7] & 0xFFFFFFEF;
                break;
            }
            case 38: {
                this.row[7] = this.row[7] & 0xFFFFFFDF;
                break;
            }
            case 39: {
                this.row[7] = this.row[7] & 0xFFFFFFBF;
                break;
            }
            case 114: {
                this.row[7] = this.row[7] & 0xFFFFFF7F;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 16: {
                this.shift = false;
                break;
            }
            case 17: {
                this.ctrl = false;
                break;
            }
            case 18: {
                this.fa = false;
                break;
            }
            case 65406: {
                this.fb = false;
                break;
            }
            case 49: {
                this.row[0] = this.row[0] | 1;
                break;
            }
            case 50: {
                this.row[0] = this.row[0] | 2;
                break;
            }
            case 51: {
                this.row[0] = this.row[0] | 4;
                break;
            }
            case 52: {
                this.row[0] = this.row[0] | 8;
                break;
            }
            case 53: {
                this.row[0] = this.row[0] | 0x10;
                break;
            }
            case 54: {
                this.row[0] = this.row[0] | 0x20;
                break;
            }
            case 55: {
                this.row[0] = this.row[0] | 0x40;
                break;
            }
            case 56: {
                this.row[0] = this.row[0] | 0x80;
                break;
            }
            case 81: {
                this.row[1] = this.row[1] | 1;
                break;
            }
            case 87: {
                this.row[1] = this.row[1] | 2;
                break;
            }
            case 69: {
                this.row[1] = this.row[1] | 4;
                break;
            }
            case 82: {
                this.row[1] = this.row[1] | 8;
                break;
            }
            case 84: {
                this.row[1] = this.row[1] | 0x10;
                break;
            }
            case 89: {
                this.row[1] = this.row[1] | 0x20;
                break;
            }
            case 85: {
                this.row[1] = this.row[1] | 0x40;
                break;
            }
            case 73: {
                this.row[1] = this.row[1] | 0x80;
                break;
            }
            case 65: {
                this.row[2] = this.row[2] | 1;
                break;
            }
            case 83: {
                this.row[2] = this.row[2] | 2;
                break;
            }
            case 68: {
                this.row[2] = this.row[2] | 4;
                break;
            }
            case 70: {
                this.row[2] = this.row[2] | 8;
                break;
            }
            case 71: {
                this.row[2] = this.row[2] | 0x10;
                break;
            }
            case 72: {
                this.row[2] = this.row[2] | 0x20;
                break;
            }
            case 74: {
                this.row[2] = this.row[2] | 0x40;
                break;
            }
            case 75: {
                this.row[2] = this.row[2] | 0x80;
                break;
            }
            case 90: {
                this.row[3] = this.row[3] | 1;
                break;
            }
            case 88: {
                this.row[3] = this.row[3] | 2;
                break;
            }
            case 67: {
                this.row[3] = this.row[3] | 4;
                break;
            }
            case 86: {
                this.row[3] = this.row[3] | 8;
                break;
            }
            case 66: {
                this.row[3] = this.row[3] | 0x10;
                break;
            }
            case 78: {
                this.row[3] = this.row[3] | 0x20;
                break;
            }
            case 77: {
                this.row[3] = this.row[3] | 0x40;
                break;
            }
            case 44: {
                this.row[3] = this.row[3] | 0x80;
                break;
            }
            case 57: {
                this.row[4] = this.row[4] | 1;
                break;
            }
            case 79: {
                this.row[4] = this.row[4] | 2;
                break;
            }
            case 76: {
                this.row[4] = this.row[4] | 4;
                break;
            }
            case 46: {
                this.row[4] = this.row[4] | 8;
                break;
            }
            case 10: {
                this.row[4] = this.row[4] | 0x10;
                break;
            }
            case 127: {
                this.row[4] = this.row[4] | 0x20;
                break;
            }
            case 155: {
                this.row[4] = this.row[4] | 0x40;
                break;
            }
            case 112: {
                this.row[4] = this.row[4] | 0x80;
                break;
            }
            case 48: {
                this.row[5] = this.row[5] | 1;
                break;
            }
            case 80: {
                this.row[5] = this.row[5] | 2;
                break;
            }
            case 59: {
                this.row[5] = this.row[5] | 4;
                break;
            }
            case 47: {
                this.row[5] = this.row[5] | 8;
                break;
            }
            case 92: {
                this.row[5] = this.row[5] | 0x10;
                break;
            }
            case 34: {
                this.row[5] = this.row[5] | 0x20;
                break;
            }
            case 37: {
                this.row[5] = this.row[5] | 0x40;
                break;
            }
            case 113: {
                this.row[5] = this.row[5] | 0x80;
                break;
            }
            case 61: {
                this.row[6] = this.row[6] | 1;
                break;
            }
            case 91: {
                this.row[6] = this.row[6] | 2;
                break;
            }
            case 93: {
                this.row[6] = this.row[6] | 4;
                break;
            }
            case 40: {
                this.row[6] = this.row[6] | 8;
                break;
            }
            case 116: {
                this.row[6] = this.row[6] | 0x10;
                break;
            }
            case 33: {
                this.row[6] = this.row[6] | 0x20;
                break;
            }
            case 36: {
                this.row[6] = this.row[6] | 0x40;
                break;
            }
            case 115: {
                this.row[6] = this.row[6] | 0x80;
                break;
            }
            case 45: {
                this.row[7] = this.row[7] | 1;
                break;
            }
            case 192: {
                this.row[7] = this.row[7] | 2;
                break;
            }
            case 222: {
                this.row[7] = this.row[7] | 4;
                break;
            }
            case 32: {
                this.row[7] = this.row[7] | 8;
                break;
            }
            case 523: {
                this.row[7] = this.row[7] | 0x10;
                break;
            }
            case 38: {
                this.row[7] = this.row[7] | 0x20;
                break;
            }
            case 39: {
                this.row[7] = this.row[7] | 0x40;
                break;
            }
            case 114: {
                this.row[7] = this.row[7] | 0x80;
            }
        }
    }
}

