/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import machine.Config;
import machine.Iq;

public final class Memory {
    public final int PAGE_SIZE = 1024;
    public final int PAGE_MASK = 1023;
    public final byte PAGE_BIT = (byte)10;
    private byte[][] Ram = new byte[64][1024];
    private byte[][] VRam = new byte[2][1024];
    private byte[][] Chars = new byte[1][1024];
    private byte[][] Monitor = new byte[4][1024];
    private byte[][] Basic6 = new byte[8][1024];
    private byte[][] BasicG = new byte[8][1024];
    private byte[][] BasicG2 = new byte[4][1024];
    private byte[][] Assembler = new byte[16][1024];
    private byte[][] Pascal = new byte[16][1024];
    private byte[][] Pascal1 = new byte[16][1024];
    private byte[][] readPages = new byte[64][];
    private byte[][] writePages = new byte[64][];
    private byte[] fakeROM = new byte[1024];
    private byte[] fakeRAM = new byte[1024];
    private Config cf;

    public Memory(Config cnf) {
        this.cf = cnf;
        this.loadRoms();
    }

    public void Reset(boolean dirty) {
        if (dirty) {
            int c = 0;
            int a = 0;
            for (int i = 0; i < 64; ++i) {
                for (int j = 0; j < 1024; ++j) {
                    this.Ram[i][j] = (byte)c;
                    if ((a = a++ & 0x7F) != 0) continue;
                    c = (char)(c ^ 0xFF);
                }
            }
        }
        for (int i = 0; i < 1024; ++i) {
            this.fakeRAM[i] = -1;
        }
        int er = this.cf.getMem64() ? 64 : 32;
        for (int i = 0; i < 63; ++i) {
            if (i < er) {
                this.writePages[i] = this.Ram[i];
                this.readPages[i] = this.writePages[i];
                continue;
            }
            this.readPages[i] = this.fakeRAM;
            this.writePages[i] = this.fakeROM;
        }
        this.readPages[63] = this.Monitor[3];
        this.writePages[63] = this.fakeROM;
        this.readPages[62] = this.Monitor[2];
        this.writePages[62] = this.fakeROM;
        this.readPages[61] = this.Monitor[1];
        this.writePages[61] = this.fakeROM;
        this.readPages[60] = this.Monitor[0];
        this.writePages[60] = this.fakeROM;
        byte by = this.cf.getVideo();
        this.cf.getClass();
        if (by == 0) {
            this.writePages[59] = this.VRam[0];
            this.readPages[59] = this.writePages[59];
        } else {
            this.writePages[59] = this.VRam[1];
            this.readPages[59] = this.writePages[59];
            this.writePages[58] = this.VRam[0];
            this.readPages[58] = this.writePages[58];
        }
        byte by2 = this.cf.getMain();
        this.cf.getClass();
        if (by2 == 1) {
            this.readPages[57] = this.Basic6[7];
            this.writePages[57] = this.fakeROM;
            this.readPages[56] = this.Basic6[6];
            this.writePages[56] = this.fakeROM;
            this.readPages[55] = this.Basic6[5];
            this.writePages[55] = this.fakeROM;
            this.readPages[54] = this.Basic6[4];
            this.writePages[54] = this.fakeROM;
            this.readPages[53] = this.Basic6[3];
            this.writePages[53] = this.fakeROM;
            this.readPages[52] = this.Basic6[2];
            this.writePages[52] = this.fakeROM;
            this.readPages[51] = this.Basic6[1];
            this.writePages[51] = this.fakeROM;
            this.readPages[50] = this.Basic6[0];
            this.writePages[50] = this.fakeROM;
        }
        if (this.cf.getMain() == this.cf.BASICG) {
            this.readPages[57] = this.BasicG[7];
            this.writePages[57] = this.fakeROM;
            this.readPages[56] = this.BasicG[6];
            this.writePages[56] = this.fakeROM;
            this.readPages[55] = this.BasicG[5];
            this.writePages[55] = this.fakeROM;
            this.readPages[54] = this.BasicG[4];
            this.writePages[54] = this.fakeROM;
            this.readPages[53] = this.BasicG[3];
            this.writePages[53] = this.fakeROM;
            this.readPages[52] = this.BasicG[2];
            this.writePages[52] = this.fakeROM;
            this.readPages[51] = this.BasicG[1];
            this.writePages[51] = this.fakeROM;
            this.readPages[50] = this.BasicG[0];
            this.writePages[50] = this.fakeROM;
            this.readPages[47] = this.BasicG2[3];
            this.writePages[47] = this.fakeROM;
            this.readPages[46] = this.BasicG2[2];
            this.writePages[46] = this.fakeROM;
            this.readPages[45] = this.BasicG2[1];
            this.writePages[45] = this.fakeROM;
            this.readPages[44] = this.BasicG2[0];
            this.writePages[44] = this.fakeROM;
        }
        if (this.cf.getMain() == this.cf.AMOS) {
            this.setAssembler();
        }
    }

    public void setAssembler() {
        this.readPages[47] = this.Assembler[15];
        this.readPages[46] = this.Assembler[14];
        this.readPages[45] = this.Assembler[13];
        this.readPages[44] = this.Assembler[12];
        this.readPages[43] = this.Assembler[11];
        this.readPages[42] = this.Assembler[10];
        this.readPages[41] = this.Assembler[9];
        this.readPages[40] = this.Assembler[8];
        this.readPages[39] = this.Assembler[7];
        this.readPages[38] = this.Assembler[6];
        this.readPages[37] = this.Assembler[5];
        this.readPages[36] = this.Assembler[4];
        this.readPages[35] = this.Assembler[3];
        this.readPages[34] = this.Assembler[2];
        this.readPages[33] = this.Assembler[1];
        this.readPages[32] = this.Assembler[0];
    }

    public void setPascal() {
        this.readPages[47] = this.Pascal[15];
        this.readPages[46] = this.Pascal[14];
        this.readPages[45] = this.Pascal[13];
        this.readPages[44] = this.Pascal[12];
        this.readPages[43] = this.Pascal[11];
        this.readPages[42] = this.Pascal[10];
        this.readPages[41] = this.Pascal[9];
        this.readPages[40] = this.Pascal[8];
        this.readPages[39] = this.Pascal[7];
        this.readPages[38] = this.Pascal[6];
        this.readPages[37] = this.Pascal[5];
        this.readPages[36] = this.Pascal[4];
        this.readPages[35] = this.Pascal[3];
        this.readPages[34] = this.Pascal[2];
        this.readPages[33] = this.Pascal[1];
        this.readPages[32] = this.Pascal[0];
    }

    public void setPascal1() {
        this.readPages[47] = this.Pascal1[15];
        this.readPages[46] = this.Pascal1[14];
        this.readPages[45] = this.Pascal1[13];
        this.readPages[44] = this.Pascal1[12];
        this.readPages[43] = this.Pascal1[11];
        this.readPages[42] = this.Pascal1[10];
        this.readPages[41] = this.Pascal1[9];
        this.readPages[40] = this.Pascal1[8];
        this.readPages[39] = this.Pascal1[7];
        this.readPages[38] = this.Pascal1[6];
        this.readPages[37] = this.Pascal1[5];
        this.readPages[36] = this.Pascal1[4];
        this.readPages[35] = this.Pascal1[3];
        this.readPages[34] = this.Pascal1[2];
        this.readPages[33] = this.Pascal1[1];
        this.readPages[32] = this.Pascal1[0];
    }

    public void setAmosNoRom() {
        this.readPages[47] = this.Ram[47];
        this.readPages[46] = this.Ram[46];
        this.readPages[45] = this.Ram[45];
        this.readPages[44] = this.Ram[44];
        this.readPages[43] = this.Ram[43];
        this.readPages[42] = this.Ram[42];
        this.readPages[41] = this.Ram[41];
        this.readPages[40] = this.Ram[40];
        this.readPages[39] = this.Ram[39];
        this.readPages[38] = this.Ram[38];
        this.readPages[37] = this.Ram[37];
        this.readPages[36] = this.Ram[36];
        this.readPages[35] = this.Ram[35];
        this.readPages[34] = this.Ram[34];
        this.readPages[33] = this.Ram[33];
        this.readPages[32] = this.Ram[32];
    }

    public void setBootstrap(boolean b) {
        if (b) {
            this.readPages[0] = this.Monitor[2];
            this.writePages[0] = this.Ram[0];
            this.readPages[1] = this.Monitor[3];
            this.writePages[1] = this.Ram[1];
        } else {
            this.writePages[0] = this.Ram[0];
            this.readPages[0] = this.writePages[0];
            this.writePages[1] = this.Ram[1];
            this.readPages[1] = this.writePages[1];
        }
    }

    public byte readByte(int address) {
        return this.readPages[address >>> 10][address & 0x3FF];
    }

    public void writeByte(int address, byte value) {
        this.writePages[address >>> 10][address & 0x3FF] = value;
    }

    public byte[][] getVRam() {
        return this.VRam;
    }

    public byte[] getChars() {
        return this.Chars[0];
    }

    private void loadRoms() {
        String romsDirectory = this.cf.getRomsDirectory();
        if (!romsDirectory.isEmpty() && !romsDirectory.endsWith("/")) {
            romsDirectory = romsDirectory + "/";
        }
        if (!this.loadRomAsFile(romsDirectory + this.cf.getCharsRom(), this.Chars, 0, 1024)) {
            this.loadRomAsResource("/roms/znaky.bin", this.Chars, 0, 1024);
        }
        if (!this.loadRomAsFile(romsDirectory + this.cf.getMonitorRom(), this.Monitor, 0, 4096)) {
            this.loadRomAsResource("/roms/Monitor.rom", this.Monitor, 0, 4096);
        }
        if (!this.loadRomAsFile(romsDirectory + this.cf.getBasic6Rom(), this.Basic6, 0, 8192)) {
            this.loadRomAsResource("/roms/Basic6.rom", this.Basic6, 0, 8192);
        }
        if (!this.loadRomAsFile(romsDirectory + this.cf.getBasicGRom(), this.BasicG, 0, 8192)) {
            this.loadRomAsResource("/roms/BasicG.rom", this.BasicG, 0, 8192);
        }
        if (!this.loadRomAsFile(romsDirectory + this.cf.getBasicG2Rom(), this.BasicG2, 0, 4096)) {
            this.loadRomAsResource("/roms/BasicG2.rom", this.BasicG2, 0, 4096);
        }
        if (!this.loadRomAsFile(romsDirectory + this.cf.getAssemblerRom(), this.Assembler, 0, 16384)) {
            this.loadRomAsResource("/roms/Assembler.rom", this.Assembler, 0, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + this.cf.getPascalRom(), this.Pascal, 0, 16384)) {
            this.loadRomAsResource("/roms/Pascal.rom", this.Pascal, 0, 16384);
        }
        if (!this.loadRomAsFile(romsDirectory + this.cf.getPascal1Rom(), this.Pascal1, 0, 16384)) {
            this.loadRomAsResource("/roms/Pascal1.rom", this.Pascal1, 0, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRomAsResource(String filename, byte[][] rom, int page, int size) {
        InputStream inRom = Iq.class.getResourceAsStream(filename);
        boolean res = false;
        if (inRom == null) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("RESOURCE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            return false;
        }
        try {
            for (int frag = 0; frag < size / 1024; ++frag) {
                int count;
                for (count = 0; count != -1 && count < 1024; count += inRom.read(rom[page + frag], count, 1024 - count)) {
                }
                if (count != 1024) {
                    String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_SIZE_ERROR");
                    System.out.println(String.format("%s: %s", msg, filename));
                    continue;
                }
                res = true;
            }
        }
        catch (IOException ex) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("RESOURCE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            Logger.getLogger(Iq.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                inRom.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (res) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_RESOURCE_LOADED");
            System.out.println(String.format("%s: %s", msg, filename));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRomAsFile(String filename, byte[][] rom, int page, int size) {
        BufferedInputStream fIn = null;
        boolean res = false;
        try {
            try {
                fIn = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException ex) {
                String msg = ResourceBundle.getBundle("machine/Bundle").getString("FILE_ROM_ERROR");
                System.out.println(String.format("%s: %s", msg, filename));
                boolean bl = false;
                try {
                    if (fIn != null) {
                        fIn.close();
                    }
                }
                catch (IOException ex2) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex2);
                }
                return bl;
            }
            for (int frag = 0; frag < size / 1024; ++frag) {
                int count;
                for (count = 0; count != -1 && count < 1024; count += fIn.read(rom[page + frag], count, 1024 - count)) {
                }
                if (count != 1024) {
                    String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_SIZE_ERROR");
                    System.out.println(String.format("%s: %s", msg, filename));
                    continue;
                }
                res = true;
            }
        }
        catch (IOException ex) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("FILE_ROM_ERROR");
            System.out.println(String.format("%s: %s", msg, filename));
            Logger.getLogger(Iq.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (res) {
            String msg = ResourceBundle.getBundle("machine/Bundle").getString("ROM_FILE_LOADED");
            System.out.println(String.format("%s: %s", msg, filename));
        }
        return res;
    }
}

