/*
 * Decompiled with CFR 0.152.
 */
package machine;

import machine.I8085;
import machine.PicState;

public final class Pic {
    private I8085 cpu;
    private int icw1;
    private int icw2;
    private int icw3;
    private int icw4;
    private int ocw1;
    private int ocw2;
    private int ocw3;
    private int irr;
    private int isr;
    public init state;
    public iack intack;

    public Pic() {
        this.Reset();
    }

    public PicState getPicSate() {
        PicState st2 = new PicState();
        st2.icw1 = this.icw1;
        st2.icw2 = this.icw2;
        st2.icw3 = this.icw3;
        st2.icw4 = this.icw4;
        st2.ocw1 = this.ocw1;
        st2.ocw2 = this.ocw2;
        st2.ocw3 = this.ocw3;
        st2.irr = this.irr;
        st2.isr = this.isr;
        st2.state = this.state;
        st2.intack = this.intack;
        return st2;
    }

    public void setPicSate(PicState st2) {
        this.icw1 = st2.icw1;
        this.icw2 = st2.icw2;
        this.icw3 = st2.icw3;
        this.icw4 = st2.icw4;
        this.ocw1 = st2.ocw1;
        this.ocw2 = st2.ocw2;
        this.ocw3 = st2.ocw3;
        this.irr = st2.irr;
        this.isr = st2.isr;
        this.state = st2.state;
        this.intack = st2.intack;
        this.checkInt();
    }

    public void Reset() {
        this.icw1 = 0;
        this.icw2 = 0;
        this.icw3 = 0;
        this.icw4 = 0;
        this.ocw1 = 0;
        this.ocw2 = 0;
        this.ocw3 = 2;
        this.irr = 0;
        this.isr = 0;
        this.state = init.DONE;
        this.intack = iack.NONE;
    }

    public void writePortA0(int value) {
        if ((value & 0x10) != 0) {
            this.icw1 = value;
            this.ocw1 = 0;
            if ((value & 1) == 0) {
                this.icw4 = 0;
            }
            this.ocw3 &= 0xF8;
            this.ocw3 |= 2;
            this.state = init.I2;
        } else if ((value & 8) != 0) {
            this.ocw3 = value;
        } else {
            this.ocw2 = value;
            this.doCommand(value);
        }
    }

    public void writePortA1(int value) {
        if (this.state == init.I2) {
            this.icw2 = value;
            this.state = (this.icw1 & 2) == 0 ? init.I3 : ((this.icw1 & 1) != 0 ? init.I4 : init.DONE);
        } else if (this.state == init.I3) {
            this.icw3 = value;
            this.state = (this.icw1 & 1) != 0 ? init.I4 : init.DONE;
        } else if (this.state == init.I4) {
            this.icw4 = value;
            this.state = init.DONE;
        } else {
            this.ocw1 = value;
            this.checkInt();
        }
    }

    public int readPortA0() {
        if ((this.ocw3 & 4) != 0) {
            return this.getPoll();
        }
        if ((this.ocw3 & 3) == 3) {
            return this.isr;
        }
        if ((this.ocw3 & 2) == 2) {
            return this.irr;
        }
        return 255;
    }

    public int readPortA1() {
        return this.ocw1;
    }

    public int getIntAckCycle() {
        switch (this.intack) {
            case CALL: {
                int rq = this.getHighest(this.irr & ~this.ocw1);
                this.isr |= this.numToBit(rq);
                this.irr &= ~this.numToBit(rq);
                this.intack = iack.ADDR;
                return 205;
            }
            case ADDR: {
                int rq = this.getHighest(this.isr);
                int a = this.icw2 << 8 & 0xFF00;
                this.cpu.setActiveInt(false);
                this.intack = iack.NONE;
                if ((this.icw4 & 2) != 0) {
                    this.doCommand(32);
                }
                if ((this.icw1 & 4) != 0) {
                    return a | this.icw1 & 0xE0 | rq << 2;
                }
                return a | this.icw1 & 0xC0 | rq << 3;
            }
        }
        return 0;
    }

    public void assertInt(int level) {
        this.irr |= this.numToBit(level);
        this.checkInt();
    }

    public void setCPU(I8085 processor) {
        this.cpu = processor;
    }

    private int numToBit(int intnum) {
        return 1 << intnum;
    }

    private int getHighest(int reg) {
        int i = 7;
        int mask = 128;
        while (i > -1) {
            if ((reg & mask) != 0) {
                return i;
            }
            --i;
            mask >>>= 1;
        }
        return -1;
    }

    public int getPoll() {
        if (this.isr == 0) {
            return 0;
        }
        return this.getHighest(this.isr) | 0x80;
    }

    private void checkInt() {
        int cu;
        int rq = this.getHighest(this.irr & ~this.ocw1);
        if (rq > (cu = this.getHighest(this.isr))) {
            this.intack = iack.CALL;
            this.cpu.setActiveInt(true);
        }
    }

    private void doCommand(int code) {
        if ((code & 0x20) != 0) {
            int rq = (code & 0x40) != 0 ? this.ocw2 & 7 : this.getHighest(this.isr);
            this.isr &= ~this.numToBit(rq);
            this.checkInt();
        }
    }

    public static enum iack {
        NONE,
        CALL,
        ADDR;

    }

    public static enum init {
        I2,
        I3,
        I4,
        DONE;

    }
}

