/*
 * Decompiled with CFR 0.152.
 */
package machine;

import machine.Pio8255Notify;

final class Pio8255 {
    public final int PP_PortA = 0;
    public final int PP_PortB = 1;
    public final int PP_PortC = 2;
    public final int PP_CWR = 3;
    public final int PP_PortCH = 4;
    public final int PP_PortCL = 5;
    private final int PP_Bit0 = 0;
    private final int PP_Bit1 = 1;
    private final int PP_Bit2 = 2;
    private final int PP_Bit3 = 3;
    private final int PP_Bit4 = 4;
    private final int PP_Bit5 = 5;
    private final int PP_Bit6 = 6;
    private final int PP_Bit7 = 7;
    private final int CWR_MASK = 128;
    private final int GA_MODE = 96;
    private final int GA_MODE0 = 0;
    private final int GA_MODE1 = 32;
    private final int GA_MODE2 = 64;
    private final int PORTA_DIR = 16;
    private final int PORTA_INP = 16;
    private final int PORTA_OUT = 0;
    private final int PORTCH_DIR = 8;
    private final int PORTCH_INP = 8;
    private final int PORTCH_OUT = 0;
    private final int GB_MODE = 4;
    private final int GB_MODE0 = 0;
    private final int GB_MODE1 = 4;
    private final int PORTB_DIR = 2;
    private final int PORTB_INP = 2;
    private final int PORTB_OUT = 0;
    private final int PORTCL_DIR = 1;
    private final int PORTCL_INP = 1;
    private final int PORTCL_OUT = 0;
    private final int BASIC_CWR = 155;
    private final int _STBA = 4;
    private final int _STBA_MASK = 16;
    private final int IBFA = 5;
    private final int IBFA_MASK = 32;
    private final int _OBFA = 7;
    private final int _OBFA_MASK = 128;
    private final int _ACKA = 6;
    private final int _ACKA_MASK = 64;
    private final int INTRA = 3;
    private final int INTRA_MASK = 8;
    private final int INTEAIN = 4;
    private final int INTEAIN_MASK = 16;
    private final int INTEAOUT = 6;
    private final int INTEAOUT_MASK = 64;
    private final int _STBB = 2;
    private final int _STBB_MASK = 4;
    private final int IBFB = 1;
    private final int IBFB_MASK = 2;
    private final int _OBFB = 1;
    private final int _OBFB_MASK = 2;
    private final int _ACKB = 2;
    private final int _ACKB_MASK = 4;
    private final int INTRB = 0;
    private final int INTRB_MASK = 1;
    private final int INTEB = 2;
    private final int INTEB_MASK = 4;
    private int CWR;
    private int InBufferA;
    private int InLatchA;
    private int OutLatchA;
    private int InBufferB;
    private int InLatchB;
    private int OutLatchB;
    private int InBufferC;
    private int OutLatchC;
    private boolean InteAin;
    private boolean InteAout;
    private boolean InteB;
    private static Pio8255Notify on;

    public Pio8255(Pio8255Notify notify) {
        on = notify;
        this.Reset();
    }

    public void Reset() {
        this.CpuWrite(3, 155);
        this.InLatchA = 0;
        this.InLatchB = 0;
    }

    public int[] getState() {
        int[] res = new int[]{this.CWR, this.OutLatchC, this.OutLatchB, this.OutLatchA, (this.InteAin ? 1 : 0) | (this.InteAout ? 2 : 0) | (this.InteB ? 4 : 0)};
        return res;
    }

    public void setState(int[] state) {
        if (state != null) {
            this.Reset();
            this.CpuWrite(3, state[0]);
            this.CpuWrite(2, state[1]);
            this.CpuWrite(1, state[2]);
            this.CpuWrite(0, state[3]);
            if ((state[4] & 1) != 0) {
                this.CpuWrite(3, 9);
            }
            if ((state[4] & 2) != 0) {
                this.CpuWrite(3, 13);
            }
            if ((state[4] & 4) != 0) {
                this.CpuWrite(3, 5);
            }
        }
    }

    private void NotifyOnWritePortC(int oldVal, int newVal) {
        int val = oldVal ^ newVal;
        if (val != 0) {
            on.OnCpuWriteC();
        } else {
            if ((val & 0xF0) != 0) {
                on.OnCpuWriteCH();
            }
            if ((val & 0xF) != 0) {
                on.OnCpuWriteCL();
            }
        }
    }

    public void CpuWrite(int dest, int val) {
        switch (dest) {
            case 0: {
                if ((this.CWR & 0x60) == 0) {
                    this.OutLatchA = val;
                    on.OnCpuWriteA();
                    break;
                }
                this.OutLatchA = val;
                int oldVal = this.OutLatchC;
                this.OutLatchC &= 0xFFFFFF77;
                this.NotifyOnWritePortC(oldVal, this.OutLatchC);
                break;
            }
            case 1: {
                if ((this.CWR & 4) == 0) {
                    this.OutLatchB = val;
                    on.OnCpuWriteB();
                    break;
                }
                this.OutLatchB = val;
                int oldVal = this.OutLatchC;
                this.OutLatchC &= 0xFFFFFFFC;
                this.NotifyOnWritePortC(oldVal, this.OutLatchC);
                break;
            }
            case 2: {
                int oldVal = this.OutLatchC;
                if ((this.CWR & 5) == 0 && (this.CWR & 0x68) == 0) {
                    this.OutLatchC = val;
                } else if ((this.CWR & 5) == 0) {
                    this.OutLatchC = this.OutLatchC & 0xF0 | val & 0xF;
                } else if ((this.CWR & 0x68) == 0) {
                    this.OutLatchC = this.OutLatchC & 0xF | val & 0xF0;
                }
                this.NotifyOnWritePortC(oldVal, this.OutLatchC);
                break;
            }
            case 3: {
                if ((val & 0x80) != 0) {
                    this.CWR = val;
                    if ((this.CWR & 0x60) == 96) {
                        this.CWR &= 0xFFFFFFDF;
                    }
                    this.InBufferA = 255;
                    this.OutLatchA = 0;
                    this.InBufferB = 255;
                    if ((this.CWR & 4) != 0) {
                        this.InLatchB = 0;
                    }
                    this.OutLatchB = 0;
                    this.InBufferC = 0;
                    if ((this.CWR & 4) == 0) {
                        this.InBufferC |= 7;
                    }
                    if ((this.CWR & 0x60) == 0) {
                        this.InBufferC |= 0xF8;
                    }
                    this.OutLatchC = 0;
                    if ((this.CWR & 4) != 0) {
                        this.OutLatchC |= 2;
                    }
                    if ((this.CWR & 0x60) != 0) {
                        this.OutLatchC |= 0x80;
                    }
                    this.InteAin = false;
                    this.InteAout = false;
                    this.InteB = false;
                    on.OnCpuWriteCWR(this.CWR);
                    this.NotifyOnWritePortC(~this.OutLatchC, this.OutLatchC);
                    break;
                }
                boolean inte = false;
                int mode = this.CWR & 0x70;
                int oldVal = this.OutLatchC;
                if ((mode == 48 || (this.CWR & 0x60) == 64) && ((val &= 0xF) & 0xE) == 8) {
                    this.InteAin = (val & 1) != 0;
                    inte = true;
                } else if ((mode == 32 || (this.CWR & 0x60) == 64) && (val & 0xE) == 12) {
                    this.InteAout = (val & 1) != 0;
                    inte = true;
                }
                if (inte) {
                    this.OutLatchC &= 0xFFFFFFF7;
                    if (this.InteAin && (this.InBufferC & 0x10) == 16 && (this.OutLatchC & 0x20) == 32 || this.InteAout && (this.InBufferC & 0x40) == 64 && (this.OutLatchC & 0x80) == 128) {
                        this.OutLatchC |= 8;
                    }
                }
                if ((this.CWR & 4) == 4 && (val & 0xE) == 4) {
                    this.InteB = (val & 1) != 0;
                    this.OutLatchC &= 0xFFFFFFFE;
                    if (this.InteB && ((this.CWR & 2) == 2 && (this.InBufferC & 4) == 4 && (this.OutLatchC & 2) == 2 || (this.CWR & 0) == 0 && (this.InBufferC & 4) == 4 && (this.OutLatchC & 2) == 2)) {
                        this.OutLatchC |= 1;
                    }
                    inte = true;
                }
                if (!inte && ((this.CWR & 5) == 0 && (this.CWR & 0x68) == 0 || (this.CWR & 5) == 0 && (this.CWR & 0x68) == 8 && val >>> 1 < 4 || (this.CWR & 5) == 1 && (this.CWR & 0x68) == 0 && val >>> 1 > 3 || (this.CWR & 5) == 0 && val >>> 1 < 3 || (this.CWR & 0x68) == 0 && val >>> 1 > 2)) {
                    this.OutLatchC = (val & 1) != 0 ? (this.OutLatchC |= 1 << (val >>> 1)) : (this.OutLatchC &= ~(1 << (val >>> 1)));
                }
                this.NotifyOnWritePortC(oldVal, this.OutLatchC);
                break;
            }
        }
    }

    public int CpuRead(int src) {
        int ret_val = 0;
        switch (src) {
            case 0: {
                int mode = this.CWR & 0x70;
                if (mode == 16) {
                    on.OnCpuReadA();
                }
                if (mode == 16) {
                    ret_val = this.InBufferA;
                }
                if (mode == 0) {
                    ret_val = this.OutLatchA & this.InBufferA;
                }
                if (mode == 32) {
                    ret_val = this.OutLatchA;
                }
                if (mode != 48 && (this.CWR & 0x60) != 64) break;
                ret_val = this.InLatchA;
                int oldVal = this.OutLatchC;
                this.OutLatchC &= 0xFFFFFFD7;
                this.NotifyOnWritePortC(oldVal, this.OutLatchC);
                break;
            }
            case 1: {
                int mode = this.CWR & 6;
                if (mode == 2) {
                    on.OnCpuReadB();
                }
                if (mode == 0) {
                    ret_val = this.OutLatchB;
                }
                if (mode == 2) {
                    ret_val = this.InBufferB;
                }
                if (mode == 4) {
                    ret_val = this.OutLatchB;
                }
                if (mode != 6) break;
                ret_val = this.InLatchB;
                int oldVal = this.OutLatchC;
                this.OutLatchC &= 0xFFFFFFFC;
                this.NotifyOnWritePortC(oldVal, this.OutLatchC);
                break;
            }
            case 2: {
                ret_val = 0;
                if ((this.CWR & 0x68) == 8) {
                    on.OnCpuReadCH();
                }
                if ((this.CWR & 5) == 1) {
                    on.OnCpuReadCL();
                }
                if ((this.CWR & 5) == 1 || (this.CWR & 0x68) == 8) {
                    on.OnCpuReadC();
                }
                if ((this.CWR & 5) == 0) {
                    ret_val |= this.OutLatchC & 0xF;
                }
                if ((this.CWR & 5) == 1) {
                    ret_val |= this.InBufferC & 0xF;
                }
                if ((this.CWR & 0x68) == 0) {
                    ret_val |= this.OutLatchC & 0xF0;
                }
                if ((this.CWR & 0x68) == 8) {
                    ret_val |= this.InBufferC & 0xF0;
                }
                switch (this.CWR & 0x60) {
                    case 32: {
                        if ((this.CWR & 0x10) == 16) {
                            ret_val &= 0xC7;
                            if (this.InteAin) {
                                ret_val |= 0x10;
                            }
                            ret_val |= this.OutLatchC & 0x20;
                        } else {
                            ret_val &= 0x37;
                            if (this.InteAout) {
                                ret_val |= 0x40;
                            }
                            ret_val |= this.OutLatchC & 0x80;
                        }
                        ret_val |= this.OutLatchC & 8;
                        break;
                    }
                    case 64: {
                        ret_val &= 7;
                        if (this.InteAin) {
                            ret_val |= 0x10;
                        }
                        ret_val |= this.OutLatchC & 0x20;
                        if (this.InteAout) {
                            ret_val |= 0x40;
                        }
                        ret_val |= this.OutLatchC & 0x80;
                        ret_val |= this.OutLatchC & 8;
                    }
                }
                if ((this.CWR & 4) != 4) break;
                ret_val &= 0xF8;
                if (this.InteB) {
                    ret_val |= 4;
                }
                ret_val |= this.OutLatchC & 1;
                ret_val = (this.CWR & 2) == 2 ? (ret_val |= this.OutLatchC & 2) : (ret_val |= this.OutLatchC & 2);
                if ((this.CWR & 0x60) != 0) break;
                ret_val &= 0xF7;
                if ((this.CWR & 8) == 8) {
                    ret_val |= this.InBufferC & 8;
                    break;
                }
                ret_val |= this.OutLatchC & 8;
                break;
            }
            case 3: {
                ret_val = this.CWR;
                break;
            }
            default: {
                ret_val = 0;
            }
        }
        return ret_val;
    }

    public void PeripheralWriteByte(int dest, int val) {
        switch (dest) {
            case 0: {
                this.InBufferA = val;
                break;
            }
            case 1: {
                this.InBufferB = val;
                break;
            }
            case 2: {
                int oldVal = this.OutLatchC;
                if ((this.CWR & 4) == 4) {
                    if ((this.CWR & 2) == 2) {
                        if ((this.InBufferC & 4) == 4 && (val & 4) == 0) {
                            this.InLatchB = this.InBufferB;
                            this.OutLatchC |= 2;
                            this.OutLatchC &= 0xFFFFFFFE;
                        } else if ((this.InBufferC & 4) == 0 && (val & 4) == 4) {
                            this.OutLatchC = this.InteB && (this.OutLatchC & 2) == 2 ? (this.OutLatchC |= 1) : (this.OutLatchC &= 0xFFFFFFFE);
                        }
                    } else if ((this.InBufferC & 4) == 4 && (val & 4) == 0) {
                        this.OutLatchC |= 2;
                        this.OutLatchC &= 0xFFFFFFFE;
                    } else if ((this.InBufferC & 4) == 0 && (val & 4) == 4) {
                        this.OutLatchC = this.InteB && (this.OutLatchC & 2) == 2 ? (this.OutLatchC |= 1) : (this.OutLatchC &= 0xFFFFFFFE);
                    }
                }
                if ((this.CWR & 0x60) != 0) {
                    if ((this.CWR & 0x60) == 64 || (this.CWR & 0x70) == 48) {
                        if ((this.InBufferC & 0x10) == 16 && (val & 0x10) == 0) {
                            this.InLatchA = this.InBufferA;
                            this.OutLatchC |= 0x20;
                            this.OutLatchC &= 0xFFFFFFF7;
                        } else if ((this.InBufferC & 0x10) == 0 && (val & 0x10) == 16) {
                            this.OutLatchC = this.InteAin && (this.OutLatchC & 0x20) == 32 ? (this.OutLatchC |= 8) : (this.OutLatchC &= 0xFFFFFFF7);
                        }
                    }
                    if ((this.CWR & 0x60) == 64 || (this.CWR & 0x70) == 32) {
                        if ((this.InBufferC & 0x40) == 64 && (val & 0x40) == 0) {
                            this.OutLatchC |= 0x80;
                            this.OutLatchC &= 0xFFFFFFF7;
                        } else if ((this.InBufferC & 0x40) == 0 && (val & 0x40) == 64) {
                            this.OutLatchC = this.InteAout && (this.OutLatchC & 0x80) == 128 ? (this.OutLatchC |= 8) : (this.OutLatchC &= 0xFFFFFFF7);
                        }
                    }
                }
                this.InBufferC = val;
                this.NotifyOnWritePortC(oldVal, this.OutLatchC);
                break;
            }
        }
    }

    public void PeripheralChangeBit(int dest, int bit, boolean state) {
        switch (dest) {
            case 0: {
                this.InBufferA &= ~(1 << bit);
                this.InBufferA |= state ? 1 << bit : 0;
                break;
            }
            case 1: {
                this.InBufferB &= ~(1 << bit);
                this.InBufferB |= state ? 1 << bit : 0;
                break;
            }
            case 2: {
                if ((this.CWR & 4) == 4 && (bit == 2 || bit == 2)) {
                    int val = bit == 2 ? this.InBufferC & 0xFFFFFFFB | (state ? 4 : 0) : this.InBufferC & 0xFFFFFFFB | (state ? 4 : 0);
                    this.PeripheralWriteByte(dest, val);
                    break;
                }
                if ((this.CWR & 0x60) != 0 && (bit == 4 || bit == 6)) {
                    int val = bit == 4 ? this.InBufferC & 0xFFFFFFEF | (state ? 16 : 0) : this.InBufferC & 0xFFFFFFBF | (state ? 64 : 0);
                    this.PeripheralWriteByte(dest, val);
                    break;
                }
                this.InBufferC &= ~(1 << bit);
                this.InBufferC |= state ? 1 << bit : 0;
                break;
            }
        }
    }

    public int PeripheralReadByte(int src) {
        int ret;
        switch (src) {
            case 0: {
                if ((this.CWR & 0x60) == 64) {
                    if ((this.InBufferC & 0x40) == 0) {
                        ret = this.OutLatchA;
                        break;
                    }
                    if ((this.InBufferC & 0x10) == 0) {
                        ret = this.InBufferA;
                        break;
                    }
                    ret = 255;
                    break;
                }
                if ((this.CWR & 0x10) == 0) {
                    ret = this.OutLatchA;
                    break;
                }
                ret = this.InBufferA;
                break;
            }
            case 1: {
                if ((this.CWR & 2) == 0) {
                    ret = this.OutLatchB;
                    break;
                }
                ret = this.InBufferB;
                break;
            }
            case 2: {
                ret = 0;
                if ((this.CWR & 5) == 0) {
                    ret |= this.OutLatchC & 7;
                } else if ((this.CWR & 5) == 1) {
                    ret |= this.InBufferC & 7;
                } else if ((this.CWR & 4) == 4) {
                    ret |= this.OutLatchC & 3;
                    ret |= this.InBufferC & 4;
                }
                if ((this.CWR & 0x68) == 0) {
                    ret |= this.OutLatchC & 0xF0;
                } else if ((this.CWR & 0x68) == 8) {
                    ret |= this.InBufferC & 0xF0;
                } else if ((this.CWR & 0x70) == 32) {
                    ret |= this.OutLatchC & 0x88;
                    ret |= this.InBufferC & 0x70;
                } else if ((this.CWR & 0x70) == 48) {
                    ret |= this.OutLatchC & 0x28;
                    ret |= this.InBufferC & 0xD0;
                } else if ((this.CWR & 0x60) == 64) {
                    ret |= this.OutLatchC & 0xA8;
                    ret |= this.InBufferC & 0x50;
                }
                if ((this.CWR & 0x60) != 0) break;
                if ((this.CWR & 5) == 0) {
                    ret |= this.OutLatchC & 8;
                    break;
                }
                if ((this.CWR & 5) != 1) break;
                ret |= this.InBufferC & 8;
                break;
            }
            default: {
                ret = 255;
            }
        }
        return ret;
    }

    public boolean PeripheralReadBit(int src, int bit) {
        boolean ret;
        switch (src) {
            case 0: {
                ret = (this.PeripheralReadByte(0) & 1 << bit) != 0;
                break;
            }
            case 1: {
                ret = (this.PeripheralReadByte(1) & 1 << bit) != 0;
                break;
            }
            case 2: {
                ret = (this.PeripheralReadByte(2) & 1 << bit) != 0;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }
}

