/*
 * Decompiled with CFR 0.152.
 */
package machine;

import java.io.File;
import java.io.IOException;
import machine.ClockTimeoutListener;
import machine.Iq;
import utils.CswFile;
import utils.TapeSignalProc;
import utils.WavFile;

public class Tape
implements ClockTimeoutListener {
    private final int ts = 2048000;
    private Iq m;
    private TapeSignalProc tsp;
    private int[] tbuff = new int[1];
    private File LoadTape;
    private File SaveTape;
    private CswFile lcsw;
    private CswFile scsw;
    private WavFile lwav;
    private int lrate;
    private int srate;
    private st lst;
    private st sst;
    private boolean record;

    public Tape(Iq machine) {
        this.m = machine;
        this.tsp = new TapeSignalProc(256);
        this.lst = this.sst = st.CLOSE;
        this.record = false;
    }

    public void openLoadTape(String canonicalPath) {
        this.LoadTape = new File(canonicalPath);
        if (this.LoadTape.exists()) {
            try {
                this.lcsw = CswFile.openCswFile(this.LoadTape);
                this.lrate = (int)(2048000L / this.lcsw.getSampleRate());
                this.lst = st.CSW;
            }
            catch (IOException ex) {
                this.lst = st.CLOSE;
                try {
                    this.lwav = WavFile.openWavFile(this.LoadTape);
                    this.lrate = (int)(2048000L / this.lwav.getSampleRate());
                    this.lst = st.WAV;
                    this.lwav.display();
                }
                catch (Exception ex1) {
                    this.lst = st.CLOSE;
                }
            }
        }
    }

    public void openSaveTape(String canonicalPath) {
        if (this.sst == st.CSW) {
            try {
                this.scsw.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.SaveTape = new File(canonicalPath);
        try {
            this.scsw = CswFile.openCswFile(this.SaveTape);
            this.srate = (int)(2048000L / this.scsw.getSampleRate());
            this.sst = st.CSW;
            this.scsw.setRecord(true);
        }
        catch (IOException ex) {
            this.sst = st.CLOSE;
        }
    }

    public void tapeStart() {
        this.m.clk.addClockTimeoutListener(this);
        this.m.clk.setTimeout(512);
    }

    public void tapeStop() {
        this.m.clk.removeClockTimeoutListener(this);
    }

    void setTapeMode(boolean rec) {
        this.record = rec;
    }

    @Override
    public void clockTimeout() {
        if (this.record) {
            if (this.sst == st.CSW) {
                this.m.clk.setTimeout(this.srate);
                this.scsw.writeSample(this.m.getTapeOut());
            } else {
                this.m.clk.setTimeout(512);
            }
        } else {
            switch (this.lst) {
                case CSW: {
                    this.m.clk.setTimeout(this.lrate);
                    this.m.setTapeIn(this.lcsw.readSample());
                    break;
                }
                case WAV: {
                    this.m.clk.setTimeout(this.lrate);
                    try {
                        this.lwav.readFrames(this.tbuff, 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m.setTapeIn(this.tsp.addSample(this.tbuff[0]));
                    break;
                }
                default: {
                    this.m.clk.setTimeout(512);
                }
            }
        }
    }

    public void closeCleanup() {
        if (this.sst == st.CSW) {
            try {
                this.scsw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static enum st {
        CLOSE,
        CSW,
        WAV;

    }
}

