/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class CswFile {
    private final String sig = "Compressed Square Wave";
    private final String app = "IQ-151 emulator\u0000";
    private final long defrate = 22050L;
    private IOState state = IOState.CLOSED;
    private boolean changed;
    private boolean last;
    private File f;
    private RandomAccessFile r;
    private long len;
    private long pulses;
    private long rate;

    public static CswFile openCswFile(File file) throws IOException {
        CswFile csw = new CswFile();
        csw.f = file;
        if (!csw.f.exists()) {
            csw.f.createNewFile();
            csw.state = IOState.CREATE;
        }
        csw.r = new RandomAccessFile(csw.f, "rw");
        if (csw.state == IOState.CREATE) {
            csw.r.write(csw.sig.getBytes());
            csw.r.writeByte(26);
            csw.r.writeByte(2);
            csw.r.writeByte(0);
            csw.rate = csw.defrate;
            csw.pulses = 0L;
            csw.changed = false;
            CswFile.putLong(csw.r, csw.rate);
            CswFile.putLong(csw.r, csw.pulses);
            csw.r.writeByte(1);
            csw.r.writeByte(0);
            csw.r.writeByte(0);
            csw.r.write(csw.app.getBytes());
            csw.state = IOState.READ;
        } else {
            byte[] tmp = new byte[csw.sig.length()];
            csw.r.read(tmp);
            if (!Arrays.equals(tmp, csw.sig.getBytes())) {
                throw new IOException("Invalid file signature");
            }
            csw.r.read(tmp, 0, 3);
            if (tmp[0] != 26) {
                throw new IOException("Invalid terminator");
            }
            if (tmp[1] < 2) {
                throw new IOException("Invalid version");
            }
            csw.rate = CswFile.getLong(csw.r);
            csw.pulses = CswFile.getLong(csw.r);
            csw.changed = false;
            csw.r.read(tmp, 0, 3);
            if (tmp[0] != 1) {
                throw new IOException("Unsupported compression");
            }
            csw.r.skipBytes(16);
            if (tmp[2] != 0) {
                csw.r.skipBytes(tmp[2] & 0xFF);
            }
            csw.state = IOState.READ;
        }
        return csw;
    }

    public void close() throws IOException {
        if (this.changed) {
            this.updateCount();
        }
        this.r.close();
        this.r = null;
        this.f = null;
        this.state = IOState.CLOSED;
    }

    public void setRecord(boolean rec) throws IOException {
        if (this.state != IOState.CLOSED) {
            if (this.changed) {
                this.updateCount();
            }
            if (rec) {
                this.r.seek(this.r.length());
                this.len = 1L;
                this.state = IOState.WRITE;
            } else {
                this.state = IOState.READ;
            }
        }
    }

    public boolean readSample() {
        if (this.state == IOState.READ) {
            if (this.len == 0L) {
                try {
                    byte b = this.r.readByte();
                    boolean bl = this.last = !this.last;
                    this.len = b == 0 ? CswFile.getLong(this.r) : (long)b & 0xFFL;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.len != 0L) {
                --this.len;
            }
        }
        return this.last;
    }

    public void writeSample(boolean s) {
        if (this.state == IOState.WRITE) {
            this.changed = true;
            if (s == this.last) {
                ++this.len;
            } else if (this.len != 0L) {
                this.pulses += this.len;
                if (this.len > 255L) {
                    try {
                        this.r.writeByte(0);
                        CswFile.putLong(this.r, this.len);
                    }
                    catch (IOException ex) {}
                } else {
                    try {
                        this.r.writeByte((int)(this.len & 0xFFL));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.last = s;
                this.len = 1L;
            }
        }
    }

    public long getSampleRate() {
        return this.rate;
    }

    private void updateCount() {
        try {
            if (this.len != 0L) {
                this.writeSample(!this.last);
            }
            long pos = this.r.getFilePointer();
            this.r.seek(29L);
            CswFile.putLong(this.r, this.pulses);
            this.changed = false;
            this.r.seek(pos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static long getLong(RandomAccessFile rr) throws IOException {
        byte[] bu = new byte[4];
        rr.read(bu, 0, 4);
        long val = bu[3] & 0xFF;
        val <<= 8;
        val |= (long)(bu[2] & 0xFF);
        val <<= 8;
        val |= (long)(bu[1] & 0xFF);
        val <<= 8;
        return val |= (long)(bu[0] & 0xFF);
    }

    private static void putLong(RandomAccessFile rr, long l) throws IOException {
        rr.write((int)(l & 0xFFL));
        rr.write((int)(l >> 8 & 0xFFL));
        rr.write((int)(l >> 16 & 0xFFL));
        rr.write((int)(l >> 24 & 0xFFL));
    }

    private static enum IOState {
        CLOSED,
        CREATE,
        READ,
        WRITE;

    }
}

